"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetCriticalityFileUploader = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _kibana_react = require("../../../common/lib/kibana/kibana_react");
var _file_picker_step = require("./components/file_picker_step");
var _validation_step = require("./components/validation_step");
var _reducer = require("./reducer");
var _helpers = require("./helpers");
var _result_step = require("./components/result_step");
var _api = require("../../api/api");
var _hooks = require("./hooks");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AssetCriticalityFileUploader = () => {
  const [state, dispatch] = (0, _react.useReducer)(_reducer.reducer, _reducer.INITIAL_STATE);
  const {
    uploadAssetCriticalityFile
  } = (0, _api.useEntityAnalyticsRoutes)();
  const {
    telemetry
  } = (0, _kibana_react.useKibana)().services;
  const onValidationComplete = (0, _react.useCallback)(({
    validatedFile,
    processingStartTime,
    processingEndTime,
    tookMs
  }) => {
    telemetry.reportAssetCriticalityCsvPreviewGenerated({
      file: {
        size: validatedFile.size
      },
      processing: {
        startTime: processingStartTime,
        endTime: processingEndTime,
        tookMs
      },
      stats: {
        validLines: validatedFile.validLines.count,
        invalidLines: validatedFile.invalidLines.count,
        totalLines: validatedFile.validLines.count + validatedFile.invalidLines.count
      }
    });
    dispatch({
      type: 'fileValidated',
      payload: {
        validatedFile: {
          name: validatedFile.name,
          size: validatedFile.size,
          validLines: {
            text: validatedFile.validLines.text,
            count: validatedFile.validLines.count
          },
          invalidLines: {
            text: validatedFile.invalidLines.text,
            count: validatedFile.invalidLines.count,
            errors: validatedFile.invalidLines.errors
          }
        }
      }
    });
  }, [telemetry]);
  const onValidationError = (0, _react.useCallback)(message => {
    dispatch({
      type: 'fileError',
      payload: {
        message
      }
    });
  }, []);
  const validateFile = (0, _hooks.useFileValidation)({
    onError: onValidationError,
    onComplete: onValidationComplete
  });
  const goToFirstStep = (0, _react.useCallback)(() => {
    dispatch({
      type: 'resetState'
    });
  }, []);
  const onFileChange = (0, _react.useCallback)(fileList => {
    const file = fileList === null || fileList === void 0 ? void 0 : fileList.item(0);
    if (!file) {
      // file removed
      goToFirstStep();
      return;
    }
    dispatch({
      type: 'loadingFile',
      payload: {
        fileName: file.name
      }
    });
    validateFile(file);
  }, [validateFile, goToFirstStep]);
  const onUploadFile = (0, _react.useCallback)(async () => {
    if ((0, _helpers.isValidationStep)(state)) {
      dispatch({
        type: 'uploadingFile'
      });
      try {
        const result = await uploadAssetCriticalityFile(state.validatedFile.validLines.text, state.validatedFile.name);
        dispatch({
          type: 'fileUploaded',
          payload: {
            response: result
          }
        });
      } catch (e) {
        dispatch({
          type: 'fileUploaded',
          payload: {
            errorMessage: e.message
          }
        });
      }
    }
  }, [state, uploadAssetCriticalityFile]);
  const steps = (0, _hooks.useNavigationSteps)(state, goToFirstStep);
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiStepsHorizontal, {
    size: "s",
    steps: steps
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement("div", null, (0, _helpers.isFilePickerStep)(state) && /*#__PURE__*/_react.default.createElement(_file_picker_step.AssetCriticalityFilePickerStep, {
    onFileChange: onFileChange,
    isLoading: state.isLoading,
    errorMessage: state.fileError
  }), (0, _helpers.isValidationStep)(state) && /*#__PURE__*/_react.default.createElement(_validation_step.AssetCriticalityValidationStep, {
    validatedFile: state.validatedFile,
    isLoading: state.isLoading,
    onReturn: goToFirstStep,
    onConfirm: onUploadFile
  }), (0, _helpers.isResultStep)(state) && /*#__PURE__*/_react.default.createElement(_result_step.AssetCriticalityResultStep, {
    result: state.fileUploadResponse,
    errorMessage: state.fileUploadError,
    validLinesAsText: state.validLinesAsText,
    onReturn: goToFirstStep
  })));
};
exports.AssetCriticalityFileUploader = AssetCriticalityFileUploader;