"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostRiskScoreQueryId = void 0;
Object.defineProperty(exports, "RISK_SCORE_RANGES", {
  enumerable: true,
  get: function () {
    return _risk_engine.RISK_LEVEL_RANGES;
  }
});
exports.formatRiskScore = exports.UserRiskScoreQueryId = exports.SEVERITY_UI_SORT_ORDER = exports.RISK_SEVERITY_COLOUR = void 0;
var _uiTheme = require("@kbn/ui-theme");
var _search_strategy = require("../../../common/search_strategy");
var _utils = require("../../overview/components/detection_response/utils");
var _risk_engine = require("../../../common/entity_analytics/risk_engine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SEVERITY_UI_SORT_ORDER = exports.SEVERITY_UI_SORT_ORDER = [_search_strategy.RiskSeverity.unknown, _search_strategy.RiskSeverity.low, _search_strategy.RiskSeverity.moderate, _search_strategy.RiskSeverity.high, _search_strategy.RiskSeverity.critical];
const RISK_SEVERITY_COLOUR = exports.RISK_SEVERITY_COLOUR = {
  [_search_strategy.RiskSeverity.unknown]: _uiTheme.euiLightVars.euiColorMediumShade,
  [_search_strategy.RiskSeverity.low]: _utils.SEVERITY_COLOR.low,
  [_search_strategy.RiskSeverity.moderate]: _utils.SEVERITY_COLOR.medium,
  [_search_strategy.RiskSeverity.high]: _utils.SEVERITY_COLOR.high,
  [_search_strategy.RiskSeverity.critical]: _utils.SEVERITY_COLOR.critical
};

// TODO #173073 @tiansivive Add to utilities in `packages/kbn-utility-types`
let UserRiskScoreQueryId = exports.UserRiskScoreQueryId = /*#__PURE__*/function (UserRiskScoreQueryId) {
  UserRiskScoreQueryId["USERS_BY_RISK"] = "UsersByRisk";
  UserRiskScoreQueryId["USER_DETAILS_RISK_SCORE"] = "UserDetailsRiskScore";
  return UserRiskScoreQueryId;
}({});
let HostRiskScoreQueryId = exports.HostRiskScoreQueryId = /*#__PURE__*/function (HostRiskScoreQueryId) {
  HostRiskScoreQueryId["DEFAULT"] = "HostRiskScore";
  HostRiskScoreQueryId["HOST_DETAILS_RISK_SCORE"] = "HostDetailsRiskScore";
  HostRiskScoreQueryId["OVERVIEW_RISKY_HOSTS"] = "OverviewRiskyHosts";
  HostRiskScoreQueryId["HOSTS_BY_RISK"] = "HostsByRisk";
  return HostRiskScoreQueryId;
}({});
/**
 *
 * @returns risk score rounded with 2 digits after the decimal separator
 * @example
 * formatRiskScore(10.555) // '10.56'
 */
const formatRiskScore = riskScore => (Math.round(riskScore * 100) / 100).toFixed(2);
exports.formatRiskScore = formatRiskScore;