"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRiskEngineStatus = exports.useIsNewRiskScoreModuleInstalled = exports.useInvalidateRiskEngineStatusQuery = void 0;
var _reactQuery = require("@tanstack/react-query");
var _react = require("react");
var _api = require("../api");
var _types = require("../../../../common/entity_analytics/risk_engine/types");
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FETCH_RISK_ENGINE_STATUS = ['GET', 'FETCH_RISK_ENGINE_STATUS'];
const useInvalidateRiskEngineStatusQuery = () => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  return (0, _react.useCallback)(() => {
    queryClient.invalidateQueries(FETCH_RISK_ENGINE_STATUS, {
      refetchType: 'active'
    });
  }, [queryClient]);
};
exports.useInvalidateRiskEngineStatusQuery = useInvalidateRiskEngineStatusQuery;
const useIsNewRiskScoreModuleInstalled = () => {
  const {
    data: riskEngineStatus,
    isLoading
  } = useRiskEngineStatus();
  if (isLoading) {
    return {
      isLoading: true
    };
  }
  return {
    isLoading: false,
    installed: !!(riskEngineStatus !== null && riskEngineStatus !== void 0 && riskEngineStatus.isNewRiskScoreModuleInstalled)
  };
};
exports.useIsNewRiskScoreModuleInstalled = useIsNewRiskScoreModuleInstalled;
const useRiskEngineStatus = () => {
  const isNewRiskScoreModuleAvailable = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('riskScoringRoutesEnabled');
  const {
    fetchRiskEngineStatus
  } = (0, _api.useEntityAnalyticsRoutes)();
  return (0, _reactQuery.useQuery)(FETCH_RISK_ENGINE_STATUS, async ({
    signal
  }) => {
    if (!isNewRiskScoreModuleAvailable) {
      return {
        isUpdateAvailable: false,
        isNewRiskScoreModuleInstalled: false,
        isNewRiskScoreModuleAvailable,
        risk_engine_status: null,
        legacy_risk_engine_status: null,
        is_max_amount_of_risk_engines_reached: false
      };
    }
    const response = await fetchRiskEngineStatus({
      signal
    });
    const isUpdateAvailable = (response === null || response === void 0 ? void 0 : response.legacy_risk_engine_status) === _types.RiskEngineStatus.ENABLED && response.risk_engine_status === _types.RiskEngineStatus.NOT_INSTALLED;
    const isNewRiskScoreModuleInstalled = response.risk_engine_status !== _types.RiskEngineStatus.NOT_INSTALLED;
    return {
      isUpdateAvailable,
      isNewRiskScoreModuleInstalled,
      isNewRiskScoreModuleAvailable,
      ...response
    };
  });
};
exports.useRiskEngineStatus = useRiskEngineStatus;