"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRiskScorePreview = void 0;
var _reactQuery = require("@tanstack/react-query");
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _api = require("../api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useRiskScorePreview = ({
  data_view_id: dataViewId,
  range,
  filter
}) => {
  const {
    fetchRiskScorePreview
  } = (0, _api.useEntityAnalyticsRoutes)();
  return (0, _reactQuery.useQuery)(['POST', 'FETCH_PREVIEW_RISK_SCORE', range, filter], async ({
    signal
  }) => {
    const params = {
      data_view_id: dataViewId
    };
    if (range) {
      var _dateMath$parse, _dateMath$parse2;
      const startTime = (_dateMath$parse = _datemath.default.parse(range.start)) === null || _dateMath$parse === void 0 ? void 0 : _dateMath$parse.utc().toISOString();
      const endTime = (_dateMath$parse2 = _datemath.default.parse(range.end, {
        roundUp: true
      })) === null || _dateMath$parse2 === void 0 ? void 0 : _dateMath$parse2.utc().toISOString();
      if (startTime && endTime) {
        params.range = {
          start: startTime,
          end: endTime
        };
      }
    }
    if (filter) {
      params.filter = filter;
    }
    const response = await fetchRiskScorePreview({
      signal,
      params
    });
    return response;
  });
};
exports.useRiskScorePreview = useRiskScorePreview;