"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEntityAnalyticsRoutes = void 0;
var _react = require("react");
var _constants = require("../../../common/constants");
var _kibana_react = require("../../common/lib/kibana/kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useEntityAnalyticsRoutes = () => {
  const http = (0, _kibana_react.useKibana)().services.http;
  return (0, _react.useMemo)(() => {
    /**
     * Fetches preview risks scores
     */
    const fetchRiskScorePreview = ({
      signal,
      params
    }) => http.fetch(_constants.RISK_SCORE_PREVIEW_URL, {
      version: '1',
      method: 'POST',
      body: JSON.stringify(params),
      signal
    });

    /**
     * Fetches risks engine status
     */
    const fetchRiskEngineStatus = ({
      signal
    }) => http.fetch(_constants.RISK_ENGINE_STATUS_URL, {
      version: '1',
      method: 'GET',
      signal
    });

    /**
     * Init risk score engine
     */
    const initRiskEngine = () => http.fetch(_constants.RISK_ENGINE_INIT_URL, {
      version: '1',
      method: 'POST'
    });

    /**
     * Enable risk score engine
     */
    const enableRiskEngine = () => http.fetch(_constants.RISK_ENGINE_ENABLE_URL, {
      version: '1',
      method: 'POST'
    });

    /**
     * Disable risk score engine
     */
    const disableRiskEngine = () => http.fetch(_constants.RISK_ENGINE_DISABLE_URL, {
      version: '1',
      method: 'POST'
    });

    /**
     * Get risk engine privileges
     */
    const fetchRiskEnginePrivileges = () => http.fetch(_constants.RISK_ENGINE_PRIVILEGES_URL, {
      version: '1',
      method: 'GET'
    });

    /**
     * Get asset criticality privileges
     */
    const fetchAssetCriticalityPrivileges = () => http.fetch(_constants.ASSET_CRITICALITY_PRIVILEGES_URL, {
      version: '1',
      method: 'GET'
    });

    /**
     * Create asset criticality
     */
    const createAssetCriticality = async params => http.fetch(_constants.ASSET_CRITICALITY_URL, {
      version: '1',
      method: 'POST',
      body: JSON.stringify({
        id_value: params.idValue,
        id_field: params.idField,
        criticality_level: params.criticalityLevel
      })
    });
    const deleteAssetCriticality = async params => {
      await http.fetch(_constants.ASSET_CRITICALITY_URL, {
        version: '1',
        method: 'DELETE',
        query: {
          id_value: params.idValue,
          id_field: params.idField
        }
      });

      // spoof a response to allow us to better distnguish a delete from a create in use_asset_criticality.ts
      return {
        deleted: true
      };
    };

    /**
     * Get asset criticality
     */
    const fetchAssetCriticality = async params => {
      return http.fetch(_constants.ASSET_CRITICALITY_URL, {
        version: '1',
        method: 'GET',
        query: {
          id_value: params.idValue,
          id_field: params.idField
        }
      });
    };
    const uploadAssetCriticalityFile = async (fileContent, fileName) => {
      const file = new File([new Blob([fileContent])], fileName, {
        type: 'text/csv'
      });
      const body = new FormData();
      body.append('file', file);
      return http.fetch(_constants.ASSET_CRITICALITY_CSV_UPLOAD_URL, {
        version: '1',
        method: 'POST',
        headers: {
          'Content-Type': undefined // Lets the browser set the appropriate content type
        },
        body
      });
    };
    const getRiskScoreIndexStatus = ({
      query,
      signal
    }) => http.fetch(_constants.RISK_SCORE_INDEX_STATUS_API_URL, {
      version: '1',
      method: 'GET',
      query,
      asSystemRequest: true,
      signal
    });

    /**
     * Fetches risk engine settings
     */
    const fetchRiskEngineSettings = () => http.fetch(_constants.RISK_ENGINE_SETTINGS_URL, {
      version: '1',
      method: 'GET'
    });
    return {
      fetchRiskScorePreview,
      fetchRiskEngineStatus,
      initRiskEngine,
      enableRiskEngine,
      disableRiskEngine,
      fetchRiskEnginePrivileges,
      fetchAssetCriticalityPrivileges,
      createAssetCriticality,
      deleteAssetCriticality,
      fetchAssetCriticality,
      uploadAssetCriticalityFile,
      getRiskScoreIndexStatus,
      fetchRiskEngineSettings
    };
  }, [http]);
};
exports.useEntityAnalyticsRoutes = useEntityAnalyticsRoutes;