"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.threatDefault = exports.stepDefineDefaultValue = exports.stepAboutDefaultValue = exports.ruleStepsOrder = exports.getStepScheduleDefaultValue = exports.defaultThreatMatchSchedule = exports.defaultSchedule = exports.defaultCustomQuery = void 0;
var _utils = require("../../../../../common/detection_engine/utils");
var _translations = require("../../../../timelines/components/timeline/translations");
var _constants = require("../../../../../common/constants");
var _constants2 = require("../../../../../common/detection_engine/constants");
var _types = require("./types");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ruleStepsOrder = exports.ruleStepsOrder = [_types.RuleStep.defineRule, _types.RuleStep.aboutRule, _types.RuleStep.scheduleRule, _types.RuleStep.ruleActions];
const threatDefault = exports.threatDefault = [{
  framework: 'MITRE ATT&CK',
  tactic: {
    id: 'none',
    name: 'none',
    reference: 'none'
  },
  technique: []
}];
const stepDefineDefaultValue = exports.stepDefineDefaultValue = {
  anomalyThreshold: 50,
  index: [],
  indexPattern: {
    fields: [],
    title: ''
  },
  machineLearningJobId: [],
  ruleType: 'query',
  threatIndex: [],
  queryBar: {
    query: {
      query: '',
      language: 'kuery'
    },
    filters: [],
    saved_id: null
  },
  threatQueryBar: {
    query: {
      query: _constants.DEFAULT_THREAT_MATCH_QUERY,
      language: 'kuery'
    },
    filters: [],
    saved_id: null
  },
  requiredFields: [],
  relatedIntegrations: [],
  threatMapping: [],
  threshold: {
    field: [],
    value: '200',
    cardinality: {
      field: [],
      value: ''
    }
  },
  timeline: {
    id: null,
    title: _translations.DEFAULT_TIMELINE_TITLE
  },
  eqlOptions: {},
  dataSourceType: _types.DataSourceType.IndexPatterns,
  newTermsFields: [],
  historyWindowSize: '7d',
  shouldLoadQueryDynamically: false,
  groupByFields: [],
  groupByRadioSelection: _types.GroupByOptions.PerRuleExecution,
  groupByDuration: {
    value: 5,
    unit: 'm'
  },
  suppressionMissingFields: _constants2.DEFAULT_SUPPRESSION_MISSING_FIELDS_STRATEGY,
  enableThresholdSuppression: false
};
const stepAboutDefaultValue = exports.stepAboutDefaultValue = {
  author: [],
  name: '',
  description: '',
  isAssociatedToEndpointList: false,
  isBuildingBlock: false,
  severity: {
    value: 'low',
    mapping: (0, _helpers.fillEmptySeverityMappings)([]),
    isMappingChecked: false
  },
  riskScore: {
    value: 21,
    mapping: [],
    isMappingChecked: false
  },
  investigationFields: [],
  references: [''],
  falsePositives: [''],
  license: '',
  ruleNameOverride: '',
  tags: [],
  timestampOverride: '',
  threat: threatDefault,
  note: '',
  setup: '',
  threatIndicatorPath: undefined,
  timestampOverrideFallbackDisabled: undefined
};
const DEFAULT_INTERVAL = '5m';
const DEFAULT_FROM = '1m';
const THREAT_MATCH_INTERVAL = '1h';
const THREAT_MATCH_FROM = '5m';
const defaultSchedule = exports.defaultSchedule = {
  interval: DEFAULT_INTERVAL,
  from: DEFAULT_FROM
};
const defaultThreatMatchSchedule = exports.defaultThreatMatchSchedule = {
  interval: THREAT_MATCH_INTERVAL,
  from: THREAT_MATCH_FROM
};
const getStepScheduleDefaultValue = ruleType => {
  return {
    interval: (0, _utils.isThreatMatchRule)(ruleType) ? THREAT_MATCH_INTERVAL : DEFAULT_INTERVAL,
    from: (0, _utils.isThreatMatchRule)(ruleType) ? THREAT_MATCH_FROM : DEFAULT_FROM
  };
};

/**
 * This default query will be used for threat query/indicator matches
 * as the default when the user swaps to using it by changing their
 * rule type from any rule type to the "threatMatchRule" type. Only
 * difference is that "*:*" is used instead of '' for its query.
 */
exports.getStepScheduleDefaultValue = getStepScheduleDefaultValue;
const threatQueryBarDefaultValue = {
  ...stepDefineDefaultValue.queryBar,
  query: {
    ...stepDefineDefaultValue.queryBar.query,
    query: '*:*'
  }
};
const defaultCustomQuery = exports.defaultCustomQuery = {
  forNormalRules: stepDefineDefaultValue.queryBar,
  forThreatMatchRules: threatQueryBarDefaultValue,
  forEsqlRules: {
    query: {
      query: '',
      language: 'esql'
    },
    filters: [],
    saved_id: null
  }
};