"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MONITORING_TAB = exports.LACK_OF_KIBANA_SECURITY_PRIVILEGES = exports.LACK_OF_KIBANA_ACTIONS_FEATURE_PRIVILEGES = exports.INSTALL_RULE_BUTTON_ARIA_LABEL = exports.INSTALL_RULE_BUTTON = exports.INITIAL_PROMPT_TEXT = exports.IMPORT_VALUE_LISTS = exports.IMPORT_RULE_BTN_TITLE = exports.IMPORT_RULE = exports.IMPORT_FAILED_DETAILED = exports.IMPORT_FAILED = exports.GO_BACK_TO_RULES_TABLE_BUTTON = exports.EXPORT_RULE = exports.EXPORT_FILENAME = exports.EXPLAIN_THEN_SUMMARIZE_RULE_DETAILS = exports.ENABLED_RULES = exports.ELASTIC_RULES = exports.EDIT_RULE_SETTINGS = exports.EDIT_PAGE_TITLE = exports.DUPLICATE_RULE = exports.DISABLED_RULES = exports.DETECTION_RULES_CONVERSATION_ID = exports.DELETE_RULE = exports.DELETE_CONFIRMATION_CONFIRM = exports.DELETE_CONFIRMATION_CANCEL = exports.DELETE = exports.DEFINITION = exports.DEFINE_RULE = exports.CUSTOM_RULES = exports.CONTINUE = exports.COLUMN_TAGS = exports.COLUMN_SNOOZE = exports.COLUMN_SEVERITY = exports.COLUMN_RULE = exports.COLUMN_RISK_SCORE = exports.COLUMN_QUERY_TIMES_TOOLTIP = exports.COLUMN_QUERY_TIMES = exports.COLUMN_LAST_UPDATE = exports.COLUMN_LAST_RESPONSE = exports.COLUMN_LAST_COMPLETE_RUN = exports.COLUMN_INTEGRATIONS = exports.COLUMN_INDEXING_TIMES_TOOLTIP = exports.COLUMN_INDEXING_TIMES = exports.COLUMN_GAP_TOOLTIP_SEE_DOCUMENTATION = exports.COLUMN_GAP = exports.COLUMN_ENABLE = exports.CLEAR_SELECTION = exports.CLEAR_RULES_TABLE_FILTERS = exports.CANCEL_BUTTON_LABEL = exports.BULK_EXPORT_CONFIRMATION_REJECTED_TITLE = exports.BULK_EXPORT_CONFIRMATION_CONFIRM = exports.BULK_EDIT_WARNING_TOAST_TITLE = exports.BULK_EDIT_WARNING_TOAST_NOTIFY = exports.BULK_EDIT_WARNING_TOAST_DESCRIPTION = exports.BULK_EDIT_FLYOUT_FORM_TAGS_REQUIRED_ERROR = exports.BULK_EDIT_FLYOUT_FORM_SAVE = exports.BULK_EDIT_FLYOUT_FORM_DELETE_TAGS_TITLE = exports.BULK_EDIT_FLYOUT_FORM_DELETE_TAGS_LABEL = exports.BULK_EDIT_FLYOUT_FORM_DELETE_TAGS_HELP_TEXT = exports.BULK_EDIT_FLYOUT_FORM_DELETE_INDEX_PATTERNS_TITLE = exports.BULK_EDIT_FLYOUT_FORM_DELETE_INDEX_PATTERNS_LABEL = exports.BULK_EDIT_FLYOUT_FORM_DELETE_INDEX_PATTERNS_HELP_TEXT = exports.BULK_EDIT_FLYOUT_FORM_DATA_VIEWS_OVERWRITE_LABEL = exports.BULK_EDIT_FLYOUT_FORM_CANCEL = exports.BULK_EDIT_FLYOUT_FORM_ADD_TAGS_TITLE = exports.BULK_EDIT_FLYOUT_FORM_ADD_TAGS_OVERWRITE_LABEL = exports.BULK_EDIT_FLYOUT_FORM_ADD_TAGS_LABEL = exports.BULK_EDIT_FLYOUT_FORM_ADD_TAGS_HELP_TEXT = exports.BULK_EDIT_FLYOUT_FORM_ADD_INDEX_PATTERNS_TITLE = exports.BULK_EDIT_FLYOUT_FORM_ADD_INDEX_PATTERNS_REQUIRED_ERROR = exports.BULK_EDIT_FLYOUT_FORM_ADD_INDEX_PATTERNS_OVERWRITE_LABEL = exports.BULK_EDIT_FLYOUT_FORM_ADD_INDEX_PATTERNS_LABEL = exports.BULK_EDIT_FLYOUT_FORM_ADD_INDEX_PATTERNS_HELP_TEXT = exports.BULK_EDIT_CONFIRMATION_REJECTED_TITLE = exports.BULK_EDIT_CONFIRMATION_CONFIRM = exports.BULK_EDIT_CONFIRMATION_CANCEL = exports.BULK_DELETE_CONFIRMATION_TITLE = exports.BULK_ACTION_TAGS = exports.BULK_ACTION_SET_SCHEDULE = exports.BULK_ACTION_MENU_TITLE = exports.BULK_ACTION_INDEX_PATTERNS = exports.BULK_ACTION_EXPORT = exports.BULK_ACTION_ENABLE = exports.BULK_ACTION_DUPLICATE = exports.BULK_ACTION_DISABLE = exports.BULK_ACTION_DELETE_TAGS = exports.BULK_ACTION_DELETE_INDEX_PATTERNS = exports.BULK_ACTION_DELETE = exports.BULK_ACTION_CONFIRMATION_PARTLY_TITLE = exports.BULK_ACTION_CONFIRMATION_CLOSE = exports.BULK_ACTION_APPLY_TIMELINE_TEMPLATE = exports.BULK_ACTION_ADD_TAGS = exports.BULK_ACTION_ADD_RULE_ACTIONS = exports.BULK_ACTION_ADD_INDEX_PATTERNS = exports.BATCH_ACTIONS = exports.ADD_PAGE_TITLE = exports.ADD_NEW_RULE = exports.ACTIONS = exports.ABOUT_RULE = exports.ABOUT = void 0;
exports.UPLOAD_VALUE_LISTS_TOOLTIP = exports.UPLOAD_VALUE_LISTS_PRIVILEGES_TOOLTIP = exports.UPDATE_RULE_BUTTON = exports.UPDATE = exports.TAGS = exports.SUCCESSFULLY_IMPORTED_RULES = exports.SINGLE_DELETE_CONFIRMATION_TITLE = exports.SHOWING_RULES = exports.SELECT_RULE = exports.SELECT_ALL_RULES = exports.SELECTED_RULES = exports.SEARCH_TAGS = exports.SEARCH_RULES = exports.SEARCH_PLACEHOLDER = exports.SCHEDULE_RULE = exports.SCHEDULE = exports.SAVED_QUERY_LOAD_ERROR_TOAST = exports.RULE_UPDATES_DOCUMENTATION_LINK = exports.RULE_MANAGEMENT_CONTEXT_TOOLTIP = exports.RULE_MANAGEMENT_CONTEXT_DESCRIPTION = exports.RULE_EXECTION_STATUS_FILTER = exports.RULE_ACTIONS = exports.RULES_TAG_SEARCH = exports.RULES_TAB = exports.RULES_BULK_EXPORT_SUCCESS_DESCRIPTION = exports.RULES_BULK_EXPORT_SUCCESS = exports.RULES_BULK_EXPORT_PREBUILT_RULES_EXCLUDED_DESCRIPTION = exports.RULES_BULK_EXPORT_FAILURE_DESCRIPTION = exports.RULES_BULK_EXPORT_FAILURE = exports.RULES_BULK_ENABLE_SUCCESS_DESCRIPTION = exports.RULES_BULK_ENABLE_SUCCESS = exports.RULES_BULK_ENABLE_FAILURE_DESCRIPTION = exports.RULES_BULK_ENABLE_FAILURE = exports.RULES_BULK_EDIT_SUCCESS_DESCRIPTION = exports.RULES_BULK_EDIT_SUCCESS_DATA_VIEW_RULES_SKIPPED_DETAIL = exports.RULES_BULK_EDIT_SUCCESS = exports.RULES_BULK_EDIT_FAILURE_DESCRIPTION = exports.RULES_BULK_EDIT_FAILURE = exports.RULES_BULK_DUPLICATE_SUCCESS_DESCRIPTION = exports.RULES_BULK_DUPLICATE_SUCCESS = exports.RULES_BULK_DUPLICATE_FAILURE_DESCRIPTION = exports.RULES_BULK_DUPLICATE_FAILURE = exports.RULES_BULK_DISABLE_SUCCESS_DESCRIPTION = exports.RULES_BULK_DISABLE_SUCCESS = exports.RULES_BULK_DISABLE_FAILURE_DESCRIPTION = exports.RULES_BULK_DISABLE_FAILURE = exports.RULES_BULK_DELETE_SUCCESS_DESCRIPTION = exports.RULES_BULK_DELETE_SUCCESS = exports.RULES_BULK_DELETE_FAILURE_DESCRIPTION = exports.RULES_BULK_DELETE_FAILURE = exports.REFRESH_RULE_POPOVER_LABEL = exports.REFRESH_RULE_POPOVER_DESCRIPTION = exports.REFRESH = exports.POPOVER_TOOLTIP_ARIA_LABEL = exports.PAGE_TITLE = exports.OVERWRITE_WITH_SAME_NAME = exports.OPTIONAL_FIELD = exports.NO_TAGS_AVAILABLE = exports.NO_RULES_BODY = exports.NO_RULES_AVAILABLE_FOR_UPGRADE_BODY = exports.NO_RULES_AVAILABLE_FOR_UPGRADE = exports.NO_RULES_AVAILABLE_FOR_INSTALL_BODY = exports.NO_RULES_AVAILABLE_FOR_INSTALL = exports.NO_RULES = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const POPOVER_TOOLTIP_ARIA_LABEL = columnName => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.popoverTooltip.ariaLabel', {
  defaultMessage: 'Tooltip for column: {columnName}',
  values: {
    columnName
  }
});
exports.POPOVER_TOOLTIP_ARIA_LABEL = POPOVER_TOOLTIP_ARIA_LABEL;
const IMPORT_RULE = exports.IMPORT_RULE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.importRuleTitle', {
  defaultMessage: 'Import rules'
});
const IMPORT_VALUE_LISTS = exports.IMPORT_VALUE_LISTS = _i18n.i18n.translate('xpack.securitySolution.lists.detectionEngine.rules.importValueListsButton', {
  defaultMessage: 'Manage value lists'
});
const UPLOAD_VALUE_LISTS_TOOLTIP = exports.UPLOAD_VALUE_LISTS_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.lists.detectionEngine.rules.uploadValueListsButtonTooltip', {
  defaultMessage: 'Use value lists to create an exception when a field value matches a value found in a list'
});
const UPLOAD_VALUE_LISTS_PRIVILEGES_TOOLTIP = exports.UPLOAD_VALUE_LISTS_PRIVILEGES_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.lists.detectionEngine.rules.uploadValueListsButtonPrivilegesTooltip', {
  defaultMessage: 'A user with manage cluster privileges must visit the Rules page before you can import value lists.'
});
const ADD_NEW_RULE = exports.ADD_NEW_RULE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.addNewRuleTitle', {
  defaultMessage: 'Create new rule'
});
const PAGE_TITLE = exports.PAGE_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.pageTitle', {
  defaultMessage: 'Rules'
});
const ADD_PAGE_TITLE = exports.ADD_PAGE_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.addPageTitle', {
  defaultMessage: 'Create'
});
const EDIT_PAGE_TITLE = exports.EDIT_PAGE_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.editPageTitle', {
  defaultMessage: 'Edit'
});
const REFRESH = exports.REFRESH = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.refreshTitle', {
  defaultMessage: 'Refresh'
});
const BATCH_ACTIONS = exports.BATCH_ACTIONS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.batchActionsTitle', {
  defaultMessage: 'Bulk actions'
});
const BULK_ACTION_ENABLE = exports.BULK_ACTION_ENABLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.enableTitle', {
  defaultMessage: 'Enable'
});
const BULK_ACTION_DISABLE = exports.BULK_ACTION_DISABLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.disableTitle', {
  defaultMessage: 'Disable'
});
const BULK_ACTION_EXPORT = exports.BULK_ACTION_EXPORT = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.exportTitle', {
  defaultMessage: 'Export'
});
const BULK_ACTION_DUPLICATE = exports.BULK_ACTION_DUPLICATE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.duplicateTitle', {
  defaultMessage: 'Duplicate'
});
const BULK_ACTION_DELETE = exports.BULK_ACTION_DELETE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.deleteTitle', {
  defaultMessage: 'Delete'
});
const BULK_ACTION_INDEX_PATTERNS = exports.BULK_ACTION_INDEX_PATTERNS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.indexPatternsTitle', {
  defaultMessage: 'Index patterns'
});
const BULK_ACTION_TAGS = exports.BULK_ACTION_TAGS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.tagsTitle', {
  defaultMessage: 'Tags'
});
const BULK_ACTION_ADD_INDEX_PATTERNS = exports.BULK_ACTION_ADD_INDEX_PATTERNS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.addIndexPatternsTitle', {
  defaultMessage: 'Add index patterns'
});
const BULK_ACTION_DELETE_INDEX_PATTERNS = exports.BULK_ACTION_DELETE_INDEX_PATTERNS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.deleteIndexPatternsTitle', {
  defaultMessage: 'Delete index patterns'
});
const BULK_ACTION_ADD_TAGS = exports.BULK_ACTION_ADD_TAGS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.addTagsTitle', {
  defaultMessage: 'Add tags'
});
const BULK_ACTION_DELETE_TAGS = exports.BULK_ACTION_DELETE_TAGS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.deleteTagsTitle', {
  defaultMessage: 'Delete tags'
});
const BULK_ACTION_APPLY_TIMELINE_TEMPLATE = exports.BULK_ACTION_APPLY_TIMELINE_TEMPLATE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.applyTimelineTemplateTitle', {
  defaultMessage: 'Apply Timeline template'
});
const BULK_ACTION_ADD_RULE_ACTIONS = exports.BULK_ACTION_ADD_RULE_ACTIONS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.addRuleActionsTitle', {
  defaultMessage: 'Add rule actions'
});
const BULK_ACTION_SET_SCHEDULE = exports.BULK_ACTION_SET_SCHEDULE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.setScheduleTitle', {
  defaultMessage: 'Update rule schedules'
});
const BULK_ACTION_MENU_TITLE = exports.BULK_ACTION_MENU_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.contextMenuTitle', {
  defaultMessage: 'Options'
});
const BULK_EDIT_WARNING_TOAST_TITLE = exports.BULK_EDIT_WARNING_TOAST_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.bulkEditWarningToastTitle', {
  defaultMessage: 'Rules updates are in progress'
});
const BULK_EDIT_WARNING_TOAST_DESCRIPTION = rulesCount => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.bulkEditWarningToastDescription', {
  values: {
    rulesCount
  },
  defaultMessage: '{rulesCount, plural, =1 {# rule is} other {# rules are}} updating.'
});
exports.BULK_EDIT_WARNING_TOAST_DESCRIPTION = BULK_EDIT_WARNING_TOAST_DESCRIPTION;
const BULK_EDIT_WARNING_TOAST_NOTIFY = exports.BULK_EDIT_WARNING_TOAST_NOTIFY = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.bulkEditWarningToastNotifyButtonLabel', {
  defaultMessage: `Notify me when done`
});
const BULK_EXPORT_CONFIRMATION_REJECTED_TITLE = rulesCount => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.bulkExportConfirmationDeniedTitle', {
  values: {
    rulesCount
  },
  defaultMessage: '{rulesCount, plural, =1 {# rule} other {# rules}} cannot be exported'
});
exports.BULK_EXPORT_CONFIRMATION_REJECTED_TITLE = BULK_EXPORT_CONFIRMATION_REJECTED_TITLE;
const BULK_EDIT_CONFIRMATION_REJECTED_TITLE = rulesCount => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.bulkEditConfirmationDeniedTitle', {
  values: {
    rulesCount
  },
  defaultMessage: '{rulesCount, plural, =1 {# rule} other {# rules}} cannot be edited'
});
exports.BULK_EDIT_CONFIRMATION_REJECTED_TITLE = BULK_EDIT_CONFIRMATION_REJECTED_TITLE;
const BULK_ACTION_CONFIRMATION_PARTLY_TITLE = customRulesCount => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.bulkActionConfirmationPartlyTitle', {
  values: {
    customRulesCount
  },
  defaultMessage: 'This action can only be applied to {customRulesCount, plural, =1 {# custom rule} other {# custom rules}}'
});
exports.BULK_ACTION_CONFIRMATION_PARTLY_TITLE = BULK_ACTION_CONFIRMATION_PARTLY_TITLE;
const BULK_EDIT_CONFIRMATION_CANCEL = exports.BULK_EDIT_CONFIRMATION_CANCEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.allRules.bulkActions.bulkEditConfirmationCancelButtonLabel', {
  defaultMessage: 'Cancel'
});
const BULK_ACTION_CONFIRMATION_CLOSE = exports.BULK_ACTION_CONFIRMATION_CLOSE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.allRules.bulkActions.bulkActionConfirmationCloseButtonLabel', {
  defaultMessage: 'Close'
});
const BULK_EDIT_CONFIRMATION_CONFIRM = customRulesCount => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.allRules.bulkActions.bulkEditConfirmation.confirmButtonLabel', {
  values: {
    customRulesCount
  },
  defaultMessage: 'Edit {customRulesCount, plural, =1 {# custom rule} other {# custom rules}}'
});
exports.BULK_EDIT_CONFIRMATION_CONFIRM = BULK_EDIT_CONFIRMATION_CONFIRM;
const BULK_EXPORT_CONFIRMATION_CONFIRM = customRulesCount => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.allRules.bulkActions.bulkExportConfirmation.confirmButtonLabel', {
  values: {
    customRulesCount
  },
  defaultMessage: 'Export {customRulesCount, plural, =1 {# custom rule} other {# custom rules}}'
});
exports.BULK_EXPORT_CONFIRMATION_CONFIRM = BULK_EXPORT_CONFIRMATION_CONFIRM;
const BULK_EDIT_FLYOUT_FORM_SAVE = exports.BULK_EDIT_FLYOUT_FORM_SAVE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.allRules.bulkActions.bulkEditFlyoutForm.saveButtonLabel', {
  defaultMessage: 'Save'
});
const BULK_EDIT_FLYOUT_FORM_CANCEL = exports.BULK_EDIT_FLYOUT_FORM_CANCEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.allRules.bulkActions.bulkEditFlyoutForm.cancelButtonLabel', {
  defaultMessage: 'Cancel'
});
const BULK_EDIT_FLYOUT_FORM_ADD_INDEX_PATTERNS_HELP_TEXT = exports.BULK_EDIT_FLYOUT_FORM_ADD_INDEX_PATTERNS_HELP_TEXT = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.allRules.bulkActions.bulkEditFlyoutForm.addIndexPatternsComboboxHelpText', {
  defaultMessage: 'Enter the pattern of Elasticsearch indices that you would like to add. By default, the dropdown includes index patterns defined in Security Solution advanced settings.'
});
const BULK_EDIT_FLYOUT_FORM_DELETE_INDEX_PATTERNS_HELP_TEXT = exports.BULK_EDIT_FLYOUT_FORM_DELETE_INDEX_PATTERNS_HELP_TEXT = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.allRules.bulkActions.bulkEditFlyoutForm.deleteIndexPatternsComboboxHelpText', {
  defaultMessage: 'Enter the pattern of Elasticsearch indices that you would like to delete. By default, the dropdown includes index patterns defined in Security Solution advanced settings.'
});
const BULK_EDIT_FLYOUT_FORM_ADD_INDEX_PATTERNS_LABEL = exports.BULK_EDIT_FLYOUT_FORM_ADD_INDEX_PATTERNS_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.allRules.bulkActions.bulkEditFlyoutForm.addIndexPatternsComboboxLabel', {
  defaultMessage: 'Add index patterns for selected rules'
});
const BULK_EDIT_FLYOUT_FORM_ADD_INDEX_PATTERNS_REQUIRED_ERROR = exports.BULK_EDIT_FLYOUT_FORM_ADD_INDEX_PATTERNS_REQUIRED_ERROR = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.allRules.bulkActions.bulkEditFlyoutForm.indexPatternsRequiredErrorMessage', {
  defaultMessage: 'A minimum of one index pattern is required.'
});
const BULK_EDIT_FLYOUT_FORM_ADD_INDEX_PATTERNS_TITLE = exports.BULK_EDIT_FLYOUT_FORM_ADD_INDEX_PATTERNS_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.allRules.bulkActions.bulkEditFlyoutForm.addIndexPatternsTitle', {
  defaultMessage: 'Add index patterns'
});
const BULK_EDIT_FLYOUT_FORM_ADD_INDEX_PATTERNS_OVERWRITE_LABEL = exports.BULK_EDIT_FLYOUT_FORM_ADD_INDEX_PATTERNS_OVERWRITE_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.allRules.bulkActions.bulkEditFlyoutForm.addIndexPatternsOverwriteCheckboxLabel', {
  defaultMessage: "Overwrite all selected rules' index patterns"
});
const BULK_EDIT_FLYOUT_FORM_DATA_VIEWS_OVERWRITE_LABEL = exports.BULK_EDIT_FLYOUT_FORM_DATA_VIEWS_OVERWRITE_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.allRules.bulkActions.bulkEditFlyoutForm.dataViewsOverwriteCheckboxLabel', {
  defaultMessage: 'Apply changes to rules configured with data views'
});
const BULK_EDIT_FLYOUT_FORM_DELETE_INDEX_PATTERNS_LABEL = exports.BULK_EDIT_FLYOUT_FORM_DELETE_INDEX_PATTERNS_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.allRules.bulkActions.bulkEditFlyoutForm.deleteIndexPatternsComboboxLabel', {
  defaultMessage: 'Delete index patterns for selected rules'
});
const BULK_EDIT_FLYOUT_FORM_DELETE_INDEX_PATTERNS_TITLE = exports.BULK_EDIT_FLYOUT_FORM_DELETE_INDEX_PATTERNS_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.allRules.bulkActions.bulkEditFlyoutForm.deleteIndexPatternsTitle', {
  defaultMessage: 'Delete index patterns'
});
const BULK_EDIT_FLYOUT_FORM_ADD_TAGS_HELP_TEXT = exports.BULK_EDIT_FLYOUT_FORM_ADD_TAGS_HELP_TEXT = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.allRules.bulkActions.bulkEditFlyoutForm.addTagsComboboxHelpText', {
  defaultMessage: 'Add one or more tags for selected rules from the dropdown. You can also enter custom identifying tags and press Enter to begin a new one.'
});
const BULK_EDIT_FLYOUT_FORM_DELETE_TAGS_HELP_TEXT = exports.BULK_EDIT_FLYOUT_FORM_DELETE_TAGS_HELP_TEXT = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.allRules.bulkActions.bulkEditFlyoutForm.deleteTagsComboboxHelpText', {
  defaultMessage: 'Delete one or more tags for selected rules from the dropdown. You can also enter custom identifying tags and press Enter to begin a new one.'
});
const BULK_EDIT_FLYOUT_FORM_ADD_TAGS_LABEL = exports.BULK_EDIT_FLYOUT_FORM_ADD_TAGS_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.allRules.bulkActions.bulkEditFlyoutForm.addTagsComboboxLabel', {
  defaultMessage: 'Add tags for selected rules'
});
const BULK_EDIT_FLYOUT_FORM_TAGS_REQUIRED_ERROR = exports.BULK_EDIT_FLYOUT_FORM_TAGS_REQUIRED_ERROR = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.allRules.bulkActions.bulkEditFlyoutForm.tagsComoboxRequiredErrorMessage', {
  defaultMessage: 'A minimum of one tag is required.'
});
const BULK_EDIT_FLYOUT_FORM_ADD_TAGS_TITLE = exports.BULK_EDIT_FLYOUT_FORM_ADD_TAGS_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.allRules.bulkActions.bulkEditFlyoutForm.addTagsTitle', {
  defaultMessage: 'Add tags'
});
const BULK_EDIT_FLYOUT_FORM_ADD_TAGS_OVERWRITE_LABEL = exports.BULK_EDIT_FLYOUT_FORM_ADD_TAGS_OVERWRITE_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.allRules.bulkActions.bulkEditFlyoutForm.addTagsOverwriteCheckboxLabel', {
  defaultMessage: "Overwrite all selected rules' tags"
});
const BULK_EDIT_FLYOUT_FORM_DELETE_TAGS_LABEL = exports.BULK_EDIT_FLYOUT_FORM_DELETE_TAGS_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.allRules.bulkActions.bulkEditFlyoutForm.deleteTagsComboboxLabel', {
  defaultMessage: 'Delete tags for selected rules'
});
const BULK_EDIT_FLYOUT_FORM_DELETE_TAGS_TITLE = exports.BULK_EDIT_FLYOUT_FORM_DELETE_TAGS_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.allRules.bulkActions.bulkEditFlyoutForm.deleteTagsTitle', {
  defaultMessage: 'Delete tags'
});
const EXPORT_FILENAME = exports.EXPORT_FILENAME = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.exportFilenameTitle', {
  defaultMessage: 'rules_export'
});
const SEARCH_RULES = exports.SEARCH_RULES = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.searchAriaLabel', {
  defaultMessage: 'Search rules'
});
const SEARCH_PLACEHOLDER = exports.SEARCH_PLACEHOLDER = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.searchPlaceholder', {
  defaultMessage: 'Rule name, index pattern (e.g., "filebeat-*"), or MITRE ATT&CK™ tactic or technique (e.g., "Defense Evasion" or "TA0005")'
});
const SHOWING_RULES = (firstInPage, lastOfPage, totalRules) => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.showingRulesTitle', {
  values: {
    firstInPage,
    lastOfPage,
    totalRules
  },
  defaultMessage: 'Showing {firstInPage}-{lastOfPage} of {totalRules} {totalRules, plural, =1 {rule} other {rules}}'
});
exports.SHOWING_RULES = SHOWING_RULES;
const SELECT_ALL_RULES = totalRules => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.selectAllRulesTitle', {
  values: {
    totalRules
  },
  defaultMessage: 'Select all {totalRules} {totalRules, plural, =1 {rule} other {rules}}'
});
exports.SELECT_ALL_RULES = SELECT_ALL_RULES;
const CLEAR_SELECTION = exports.CLEAR_SELECTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.clearSelectionTitle', {
  defaultMessage: 'Clear selection'
});
const SELECTED_RULES = selectedRules => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.selectedRulesTitle', {
  values: {
    selectedRules
  },
  defaultMessage: 'Selected {selectedRules} {selectedRules, plural, =1 {rule} other {rules}}'
});
exports.SELECTED_RULES = SELECTED_RULES;
const EDIT_RULE_SETTINGS = exports.EDIT_RULE_SETTINGS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.actions.editRuleSettingsDescription', {
  defaultMessage: 'Edit rule settings'
});
const LACK_OF_KIBANA_ACTIONS_FEATURE_PRIVILEGES = exports.LACK_OF_KIBANA_ACTIONS_FEATURE_PRIVILEGES = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.actions.lackOfKibanaActionsFeaturePrivileges', {
  defaultMessage: 'You do not have Kibana Actions privileges'
});
const LACK_OF_KIBANA_SECURITY_PRIVILEGES = exports.LACK_OF_KIBANA_SECURITY_PRIVILEGES = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.actions.lackOfKibanaSecurityPrivileges', {
  defaultMessage: 'You do not have Kibana Security privileges'
});
const DUPLICATE_RULE = exports.DUPLICATE_RULE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.actions.duplicateRuleDescription', {
  defaultMessage: 'Duplicate rule'
});
const EXPORT_RULE = exports.EXPORT_RULE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.actions.exportRuleDescription', {
  defaultMessage: 'Export rule'
});
const DELETE_RULE = exports.DELETE_RULE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.actions.deleteRuleDescription', {
  defaultMessage: 'Delete rule'
});
const COLUMN_RULE = exports.COLUMN_RULE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.columns.ruleTitle', {
  defaultMessage: 'Rule'
});
const COLUMN_RISK_SCORE = exports.COLUMN_RISK_SCORE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.columns.riskScoreTitle', {
  defaultMessage: 'Risk score'
});
const COLUMN_SEVERITY = exports.COLUMN_SEVERITY = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.columns.severityTitle', {
  defaultMessage: 'Severity'
});
const COLUMN_LAST_COMPLETE_RUN = exports.COLUMN_LAST_COMPLETE_RUN = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.columns.lastRunTitle', {
  defaultMessage: 'Last run'
});
const COLUMN_LAST_UPDATE = exports.COLUMN_LAST_UPDATE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.columns.lastUpdateTitle', {
  defaultMessage: 'Last updated'
});
const COLUMN_LAST_RESPONSE = exports.COLUMN_LAST_RESPONSE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.columns.lastResponseTitle', {
  defaultMessage: 'Last response'
});
const COLUMN_TAGS = exports.COLUMN_TAGS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.columns.tagsTitle', {
  defaultMessage: 'Tags'
});
const COLUMN_INTEGRATIONS = exports.COLUMN_INTEGRATIONS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.columns.integrationsTitle', {
  defaultMessage: 'Integrations'
});
const COLUMN_ENABLE = exports.COLUMN_ENABLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.columns.enabledTitle', {
  defaultMessage: 'Enabled'
});
const COLUMN_SNOOZE = exports.COLUMN_SNOOZE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.columns.snoozeTitle', {
  defaultMessage: 'Notify'
});
const COLUMN_INDEXING_TIMES = exports.COLUMN_INDEXING_TIMES = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.columns.indexingTimes', {
  defaultMessage: 'Indexing Time (ms)'
});
const COLUMN_INDEXING_TIMES_TOOLTIP = exports.COLUMN_INDEXING_TIMES_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.columns.indexingTimesTooltip', {
  defaultMessage: 'Total time spent indexing alerts during last Rule execution'
});
const COLUMN_QUERY_TIMES = exports.COLUMN_QUERY_TIMES = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.columns.queryTimes', {
  defaultMessage: 'Query Time (ms)'
});
const COLUMN_QUERY_TIMES_TOOLTIP = exports.COLUMN_QUERY_TIMES_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.columns.queryTimesTooltip', {
  defaultMessage: 'Total time spent querying source indices during last Rule execution'
});
const COLUMN_GAP = exports.COLUMN_GAP = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.columns.gap', {
  defaultMessage: 'Last Gap (if any)'
});
const COLUMN_GAP_TOOLTIP_SEE_DOCUMENTATION = exports.COLUMN_GAP_TOOLTIP_SEE_DOCUMENTATION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.columns.gapTooltipSeeDocsDescription', {
  defaultMessage: 'see documentation'
});
const RULES_TAB = exports.RULES_TAB = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.tabs.rules', {
  defaultMessage: 'Rules'
});
const MONITORING_TAB = exports.MONITORING_TAB = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.tabs.monitoring', {
  defaultMessage: 'Rule Monitoring'
});
const ENABLED_RULES = exports.ENABLED_RULES = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.filters.enabledRulesTitle', {
  defaultMessage: 'Enabled rules'
});
const DISABLED_RULES = exports.DISABLED_RULES = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.filters.disabledRulesTitle', {
  defaultMessage: 'Disabled rules'
});
const CUSTOM_RULES = exports.CUSTOM_RULES = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.filters.customRulesTitle', {
  defaultMessage: 'Custom rules'
});
const ELASTIC_RULES = exports.ELASTIC_RULES = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.filters.elasticRulesTitle', {
  defaultMessage: 'Elastic rules'
});
const TAGS = exports.TAGS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.filters.tagsLabel', {
  defaultMessage: 'Tags'
});
const SEARCH_TAGS = exports.SEARCH_TAGS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.filters.searchTagsPlaceholder', {
  defaultMessage: 'Search tags'
});
const RULES_TAG_SEARCH = exports.RULES_TAG_SEARCH = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.filters.rulesTagSearchText', {
  defaultMessage: 'Rules tag search'
});
const NO_TAGS_AVAILABLE = exports.NO_TAGS_AVAILABLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.filters.noTagsAvailableDescription', {
  defaultMessage: 'No tags available'
});
const RULE_EXECTION_STATUS_FILTER = exports.RULE_EXECTION_STATUS_FILTER = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.filters.ruleExecutionStatusFilter', {
  defaultMessage: 'Select rule execution status to filter by'
});
const NO_RULES = exports.NO_RULES = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.filters.noRulesTitle', {
  defaultMessage: 'No rules found'
});
const NO_RULES_BODY = exports.NO_RULES_BODY = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.filters.noRulesBodyTitle', {
  defaultMessage: "We weren't able to find any rules with the above filters."
});
const NO_RULES_AVAILABLE_FOR_INSTALL = exports.NO_RULES_AVAILABLE_FOR_INSTALL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.addRules.noRulesTitle', {
  defaultMessage: 'All Elastic rules have been installed'
});
const NO_RULES_AVAILABLE_FOR_INSTALL_BODY = exports.NO_RULES_AVAILABLE_FOR_INSTALL_BODY = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.addRules.noRulesBodyTitle', {
  defaultMessage: 'There are no prebuilt detection rules available for installation'
});
const NO_RULES_AVAILABLE_FOR_UPGRADE = exports.NO_RULES_AVAILABLE_FOR_UPGRADE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.noRulesTitle', {
  defaultMessage: 'All Elastic rules are up to date'
});
const NO_RULES_AVAILABLE_FOR_UPGRADE_BODY = exports.NO_RULES_AVAILABLE_FOR_UPGRADE_BODY = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.noRulesBodyTitle', {
  defaultMessage: 'There are currently no available updates to your installed Elastic rules.'
});
const DEFINE_RULE = exports.DEFINE_RULE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.defineRuleTitle', {
  defaultMessage: 'Define rule'
});
const ABOUT_RULE = exports.ABOUT_RULE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.aboutRuleTitle', {
  defaultMessage: 'About rule'
});
const SCHEDULE_RULE = exports.SCHEDULE_RULE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.scheduleRuleTitle', {
  defaultMessage: 'Schedule rule'
});
const RULE_ACTIONS = exports.RULE_ACTIONS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.ruleActionsTitle', {
  defaultMessage: 'Rule actions'
});
const DEFINITION = exports.DEFINITION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.stepDefinitionTitle', {
  defaultMessage: 'Definition'
});
const ABOUT = exports.ABOUT = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.stepAboutTitle', {
  defaultMessage: 'About'
});
const SCHEDULE = exports.SCHEDULE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.stepScheduleTitle', {
  defaultMessage: 'Schedule'
});
const ACTIONS = exports.ACTIONS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.stepActionsTitle', {
  defaultMessage: 'Actions'
});
const OPTIONAL_FIELD = exports.OPTIONAL_FIELD = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.optionalFieldDescription', {
  defaultMessage: 'Optional'
});
const CONTINUE = exports.CONTINUE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.continueButtonTitle', {
  defaultMessage: 'Continue'
});
const UPDATE = exports.UPDATE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.updateButtonTitle', {
  defaultMessage: 'Update'
});
const DELETE = exports.DELETE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.deleteDescription', {
  defaultMessage: 'Delete'
});
const IMPORT_RULE_BTN_TITLE = exports.IMPORT_RULE_BTN_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.importRuleModal.importRuleTitle', {
  defaultMessage: 'Import'
});
const SELECT_RULE = exports.SELECT_RULE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.importRuleModal.selectRuleDescription', {
  defaultMessage: 'Select rules to import. Associated rule actions and exceptions can be included.'
});
const INITIAL_PROMPT_TEXT = exports.INITIAL_PROMPT_TEXT = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.importRuleModal.initialPromptTextDescription', {
  defaultMessage: 'Select or drag and drop a valid rules_export.ndjson file'
});
const OVERWRITE_WITH_SAME_NAME = exports.OVERWRITE_WITH_SAME_NAME = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.importRuleModal.overwriteDescription', {
  defaultMessage: 'Overwrite existing detection rules with conflicting "rule_id"'
});
const SUCCESSFULLY_IMPORTED_RULES = totalRules => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.importRuleModal.successfullyImportedRulesTitle', {
  values: {
    totalRules
  },
  defaultMessage: 'Successfully imported {totalRules} {totalRules, plural, =1 {rule} other {rules}}'
});
exports.SUCCESSFULLY_IMPORTED_RULES = SUCCESSFULLY_IMPORTED_RULES;
const IMPORT_FAILED = totalRules => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.importRuleModal.importFailedTitle', {
  values: {
    totalRules
  },
  defaultMessage: 'Failed to import {totalRules} {totalRules, plural, =1 {rule} other {rules}}'
});
exports.IMPORT_FAILED = IMPORT_FAILED;
const IMPORT_FAILED_DETAILED = message => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.importRuleModal.importFailedDetailedTitle', {
  values: {
    message
  },
  defaultMessage: '{message}'
});
exports.IMPORT_FAILED_DETAILED = IMPORT_FAILED_DETAILED;
const BULK_DELETE_CONFIRMATION_TITLE = exports.BULK_DELETE_CONFIRMATION_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.allRules.bulkDeleteConfirmationTitle', {
  defaultMessage: 'Confirm bulk deletion'
});
const SINGLE_DELETE_CONFIRMATION_TITLE = exports.SINGLE_DELETE_CONFIRMATION_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.allRules.singleDeleteConfirmationTitle', {
  defaultMessage: 'Confirm deletion'
});
const DELETE_CONFIRMATION_CONFIRM = exports.DELETE_CONFIRMATION_CONFIRM = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.allRules.deleteConfirmationConfirm', {
  defaultMessage: 'Delete'
});
const DELETE_CONFIRMATION_CANCEL = exports.DELETE_CONFIRMATION_CANCEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.components.allRules.deleteConfirmationCancel', {
  defaultMessage: 'Cancel'
});
const REFRESH_RULE_POPOVER_DESCRIPTION = exports.REFRESH_RULE_POPOVER_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.refreshRulePopoverDescription', {
  defaultMessage: 'Automatically refresh table'
});
const REFRESH_RULE_POPOVER_LABEL = exports.REFRESH_RULE_POPOVER_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.refreshRulePopoverLabel', {
  defaultMessage: 'Refresh settings'
});
const CLEAR_RULES_TABLE_FILTERS = exports.CLEAR_RULES_TABLE_FILTERS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.clearRulesTableFilters', {
  defaultMessage: 'Clear filters'
});

/**
 * Bulk Export
 */

const RULES_BULK_EXPORT_SUCCESS = exports.RULES_BULK_EXPORT_SUCCESS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.export.successToastTitle', {
  defaultMessage: 'Rules exported'
});
const RULES_BULK_EXPORT_SUCCESS_DESCRIPTION = (exportedRules, totalRules) => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.export.successToastDescription', {
  values: {
    totalRules,
    exportedRules
  },
  defaultMessage: 'Successfully exported {exportedRules} of {totalRules} {totalRules, plural, =1 {rule} other {rules}}.'
});
exports.RULES_BULK_EXPORT_SUCCESS_DESCRIPTION = RULES_BULK_EXPORT_SUCCESS_DESCRIPTION;
const RULES_BULK_EXPORT_PREBUILT_RULES_EXCLUDED_DESCRIPTION = exports.RULES_BULK_EXPORT_PREBUILT_RULES_EXCLUDED_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.export.prebuiltRulesExcludedToastDescription', {
  defaultMessage: 'Prebuilt rules were excluded from the resulting file.'
});
const RULES_BULK_EXPORT_FAILURE = exports.RULES_BULK_EXPORT_FAILURE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.export.errorToastTitle', {
  defaultMessage: 'Error exporting rules'
});
const RULES_BULK_EXPORT_FAILURE_DESCRIPTION = rulesCount => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.export.errorToastDescription', {
  values: {
    rulesCount
  },
  defaultMessage: '{rulesCount, plural, =1 {# rule is} other {# rules are}} failed to export.'
});

/**
 * Bulk Duplicate
 */
exports.RULES_BULK_EXPORT_FAILURE_DESCRIPTION = RULES_BULK_EXPORT_FAILURE_DESCRIPTION;
const RULES_BULK_DUPLICATE_SUCCESS = exports.RULES_BULK_DUPLICATE_SUCCESS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.duplicate.successToastTitle', {
  defaultMessage: 'Rules duplicated'
});
const RULES_BULK_DUPLICATE_SUCCESS_DESCRIPTION = totalRules => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.duplicate.successToastDescription', {
  values: {
    totalRules
  },
  defaultMessage: 'Successfully duplicated {totalRules, plural, =1 {{totalRules} rule} other {{totalRules} rules}}'
});
exports.RULES_BULK_DUPLICATE_SUCCESS_DESCRIPTION = RULES_BULK_DUPLICATE_SUCCESS_DESCRIPTION;
const RULES_BULK_DUPLICATE_FAILURE = exports.RULES_BULK_DUPLICATE_FAILURE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.duplicate.errorToastTitle', {
  defaultMessage: 'Error duplicating rule'
});
const RULES_BULK_DUPLICATE_FAILURE_DESCRIPTION = rulesCount => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.duplicate.errorToastDescription', {
  values: {
    rulesCount
  },
  defaultMessage: '{rulesCount, plural, =1 {# rule is} other {# rules are}} failed to duplicate.'
});

/**
 * Bulk Delete
 */
exports.RULES_BULK_DUPLICATE_FAILURE_DESCRIPTION = RULES_BULK_DUPLICATE_FAILURE_DESCRIPTION;
const RULES_BULK_DELETE_SUCCESS = exports.RULES_BULK_DELETE_SUCCESS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.delete.successToastTitle', {
  defaultMessage: 'Rules deleted'
});
const RULES_BULK_DELETE_SUCCESS_DESCRIPTION = totalRules => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.delete.successToastDescription', {
  values: {
    totalRules
  },
  defaultMessage: 'Successfully deleted {totalRules, plural, =1 {{totalRules} rule} other {{totalRules} rules}}'
});
exports.RULES_BULK_DELETE_SUCCESS_DESCRIPTION = RULES_BULK_DELETE_SUCCESS_DESCRIPTION;
const RULES_BULK_DELETE_FAILURE = exports.RULES_BULK_DELETE_FAILURE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.delete.errorToastTitle', {
  defaultMessage: 'Error deleting rules'
});
const RULES_BULK_DELETE_FAILURE_DESCRIPTION = rulesCount => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.delete.errorToastDescription', {
  values: {
    rulesCount
  },
  defaultMessage: '{rulesCount, plural, =1 {# rule is} other {# rules are}} failed to delete.'
});

/**
 * Bulk Enable
 */
exports.RULES_BULK_DELETE_FAILURE_DESCRIPTION = RULES_BULK_DELETE_FAILURE_DESCRIPTION;
const RULES_BULK_ENABLE_SUCCESS = exports.RULES_BULK_ENABLE_SUCCESS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.enable.successToastTitle', {
  defaultMessage: 'Rules enabled'
});
const RULES_BULK_ENABLE_SUCCESS_DESCRIPTION = totalRules => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkAction.enable.successToastDescription', {
  values: {
    totalRules
  },
  defaultMessage: 'Successfully enabled {totalRules, plural, =1 {{totalRules} rule} other {{totalRules} rules}}'
});
exports.RULES_BULK_ENABLE_SUCCESS_DESCRIPTION = RULES_BULK_ENABLE_SUCCESS_DESCRIPTION;
const RULES_BULK_ENABLE_FAILURE = exports.RULES_BULK_ENABLE_FAILURE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.enable.errorToastTitle', {
  defaultMessage: 'Error enabling rules'
});
const RULES_BULK_ENABLE_FAILURE_DESCRIPTION = rulesCount => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.enable.errorToastDescription', {
  values: {
    rulesCount
  },
  defaultMessage: '{rulesCount, plural, =1 {# rule is} other {# rules are}} failed to enable.'
});

/**
 * Bulk Disable
 */
exports.RULES_BULK_ENABLE_FAILURE_DESCRIPTION = RULES_BULK_ENABLE_FAILURE_DESCRIPTION;
const RULES_BULK_DISABLE_SUCCESS = exports.RULES_BULK_DISABLE_SUCCESS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.disable.successToastTitle', {
  defaultMessage: 'Rules disabled'
});
const RULES_BULK_DISABLE_SUCCESS_DESCRIPTION = totalRules => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.disable.successToastDescription', {
  values: {
    totalRules
  },
  defaultMessage: 'Successfully disabled {totalRules, plural, =1 {{totalRules} rule} other {{totalRules} rules}}'
});
exports.RULES_BULK_DISABLE_SUCCESS_DESCRIPTION = RULES_BULK_DISABLE_SUCCESS_DESCRIPTION;
const RULES_BULK_DISABLE_FAILURE = exports.RULES_BULK_DISABLE_FAILURE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.disable.errorToastTitle', {
  defaultMessage: 'Error disabling rules'
});
const RULES_BULK_DISABLE_FAILURE_DESCRIPTION = rulesCount => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.disable.errorToastDescription', {
  values: {
    rulesCount
  },
  defaultMessage: '{rulesCount, plural, =1 {# rule is} other {# rules are}} failed to disable.'
});

/**
 * Bulk Edit
 */
exports.RULES_BULK_DISABLE_FAILURE_DESCRIPTION = RULES_BULK_DISABLE_FAILURE_DESCRIPTION;
const RULES_BULK_EDIT_SUCCESS = exports.RULES_BULK_EDIT_SUCCESS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.edit.successToastTitle', {
  defaultMessage: 'Rules updated'
});
const RULES_BULK_EDIT_SUCCESS_DESCRIPTION = (succeededRulesCount, skippedRulesCount) => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.edit.successToastDescription', {
  values: {
    succeededRulesCount,
    skippedRulesCount
  },
  defaultMessage: `{succeededRulesCount, plural, =0 {} =1 {You've successfully updated # rule. } other {You've successfully updated # rules. }}
        {skippedRulesCount, plural, =0 {} =1 { # rule was skipped.} other { # rules were skipped.}}
        `
});
exports.RULES_BULK_EDIT_SUCCESS_DESCRIPTION = RULES_BULK_EDIT_SUCCESS_DESCRIPTION;
const RULES_BULK_EDIT_SUCCESS_DATA_VIEW_RULES_SKIPPED_DETAIL = exports.RULES_BULK_EDIT_SUCCESS_DATA_VIEW_RULES_SKIPPED_DETAIL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.edit.successIndexEditToastDescription', {
  defaultMessage: 'If you did not select to apply changes to rules using Kibana data views, those rules were not updated and will continue using data views.'
});
const RULES_BULK_EDIT_FAILURE = exports.RULES_BULK_EDIT_FAILURE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.edit.errorToastTitle', {
  defaultMessage: 'Error updating rules'
});
const RULES_BULK_EDIT_FAILURE_DESCRIPTION = (failedRulesCount, skippedRulesCount) => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.edit.errorToastDescription', {
  values: {
    failedRulesCount,
    skippedRulesCount
  },
  defaultMessage: '{failedRulesCount, plural, =0 {} =1 {# rule} other {# rules}} failed to update. {skippedRulesCount, plural, =0 {} =1 { # rule was skipped.} other { # rules were skipped.}}'
});
exports.RULES_BULK_EDIT_FAILURE_DESCRIPTION = RULES_BULK_EDIT_FAILURE_DESCRIPTION;
const CANCEL_BUTTON_LABEL = exports.CANCEL_BUTTON_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.cancelButtonLabel', {
  defaultMessage: 'Cancel'
});
const SAVED_QUERY_LOAD_ERROR_TOAST = exports.SAVED_QUERY_LOAD_ERROR_TOAST = _i18n.i18n.translate('xpack.securitySolution.hooks.useGetSavedQuery.errorToastMessage', {
  defaultMessage: 'Failed to load the saved query'
});

// Prompt Context i18n
const RULE_MANAGEMENT_CONTEXT_DESCRIPTION = exports.RULE_MANAGEMENT_CONTEXT_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleManagement.ruleManagementContextDescription', {
  defaultMessage: 'Selected Detection Rules'
});
const EXPLAIN_THEN_SUMMARIZE_RULE_DETAILS = exports.EXPLAIN_THEN_SUMMARIZE_RULE_DETAILS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleManagement.explainThenSummarizeRuleDetails', {
  defaultMessage: "Please explain the selected rules above. For each rule, highlight why they are relevant, the query as published on Elastic's detection rules repository and an in-depth explanation of it, and what they typically mean for an organization if detected."
});
const DETECTION_RULES_CONVERSATION_ID = exports.DETECTION_RULES_CONVERSATION_ID = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleManagement.detectionRulesConversationId', {
  defaultMessage: 'Detection Rules'
});
const RULE_MANAGEMENT_CONTEXT_TOOLTIP = exports.RULE_MANAGEMENT_CONTEXT_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleManagement.ruleManagementContextTooltip', {
  defaultMessage: 'Add this alert as context'
});
const INSTALL_RULE_BUTTON = exports.INSTALL_RULE_BUTTON = _i18n.i18n.translate('xpack.securitySolution.addRules.installRuleButton', {
  defaultMessage: 'Install rule'
});
const INSTALL_RULE_BUTTON_ARIA_LABEL = ruleName => _i18n.i18n.translate('xpack.securitySolution.addRules.installRuleButton.ariaLabel', {
  defaultMessage: 'Install "{ruleName}"',
  values: {
    ruleName
  }
});
exports.INSTALL_RULE_BUTTON_ARIA_LABEL = INSTALL_RULE_BUTTON_ARIA_LABEL;
const UPDATE_RULE_BUTTON = exports.UPDATE_RULE_BUTTON = _i18n.i18n.translate('xpack.securitySolution.addRules.upgradeRuleButton', {
  defaultMessage: 'Update rule'
});
const GO_BACK_TO_RULES_TABLE_BUTTON = exports.GO_BACK_TO_RULES_TABLE_BUTTON = _i18n.i18n.translate('xpack.securitySolution.addRules.goBackToRulesTableButton', {
  defaultMessage: 'Go back to installed Elastic rules'
});
const RULE_UPDATES_DOCUMENTATION_LINK = exports.RULE_UPDATES_DOCUMENTATION_LINK = _i18n.i18n.translate('xpack.securitySolution.ruleUpdates.documentationLink', {
  defaultMessage: "See what's new in Prebuilt Security Detection Rules"
});