"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Alerts = void 0;
var _react = _interopRequireDefault(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _public = require("@kbn/usage-collection-plugin/public");
var _constants = require("../../../../common/constants");
var _ = require("../../../app/404");
var i18n = _interopRequireWildcard(require("./translations"));
var _detection_engine = require("../detection_engine/detection_engine");
var _spy_routes = require("../../../common/utils/route/spy_routes");
var _use_readonly_header = require("../../../use_readonly_header");
var _alert_details_redirect = require("./alert_details_redirect");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertsRoute = () => /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
  viewId: _constants.SecurityPageName.alerts
}, /*#__PURE__*/_react.default.createElement(_detection_engine.DetectionEnginePage, null), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
  pageName: _constants.SecurityPageName.alerts
}));
const AlertsContainerComponent = () => {
  (0, _use_readonly_header.useReadonlyHeader)(i18n.READ_ONLY_BADGE_TOOLTIP);
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.ALERTS_PATH,
    exact: true,
    component: AlertsRoute
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.ALERT_DETAILS_REDIRECT_PATH}/:alertId`,
    component: _alert_details_redirect.AlertDetailsRedirect
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    component: _.NotFoundPage
  }));
};
const Alerts = exports.Alerts = /*#__PURE__*/_react.default.memo(AlertsContainerComponent);