"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUseActionColumnHook = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _stateful_event_context = require("../../../common/components/events_viewer/stateful_event_context");
var _selectors = require("../../../common/components/events_viewer/selectors");
var _control_columns = require("../../../timelines/components/timeline/body/control_columns");
var _use_license = require("../../../common/hooks/use_license");
var _default_config = require("../../components/alerts_table/default_config");
var _row_action = require("../../../common/components/control_columns/row_action");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getUseActionColumnHook = tableId => () => {
  const license = (0, _use_license.useLicense)();
  const isEnterprisePlus = license.isEnterprise();
  const ACTION_BUTTON_COUNT = tableId === _securitysolutionDataTable.TableId.alertsOnCasePage ? 3 : isEnterprisePlus ? 5 : 4;
  const eventContext = (0, _react.useContext)(_stateful_event_context.StatefulEventContext);
  const leadingControlColumn = (0, _react.useMemo)(() => (0, _control_columns.getDefaultControlColumn)(ACTION_BUTTON_COUNT)[0], [ACTION_BUTTON_COUNT]);
  const {
    dataTable: {
      columns: columnHeaders,
      showCheckboxes,
      selectedEventIds,
      loadingEventIds
    } = (0, _default_config.getAlertsDefaultModel)(license)
  } = (0, _reactRedux.useSelector)(state => (0, _selectors.eventsViewerSelector)(state, tableId));
  const renderCustomActionsRow = (0, _react.useCallback)(({
    rowIndex,
    cveProps,
    setIsActionLoading,
    refresh: alertsTableRefresh,
    clearSelection,
    ecsAlert: alert,
    nonEcsData
  }) => {
    const timelineItem = {
      _id: alert._id,
      _index: alert._index,
      ecs: alert,
      data: nonEcsData
    };
    return /*#__PURE__*/_react.default.createElement(_row_action.RowAction, {
      columnId: `actions-${rowIndex}`,
      columnHeaders: columnHeaders,
      controlColumn: leadingControlColumn,
      data: timelineItem,
      disabled: false,
      index: rowIndex,
      isDetails: cveProps.isDetails,
      isExpanded: cveProps.isExpanded,
      isEventViewer: false,
      isExpandable: cveProps.isExpandable,
      loadingEventIds: loadingEventIds,
      onRowSelected: () => {},
      rowIndex: cveProps.rowIndex,
      colIndex: cveProps.colIndex,
      pageRowIndex: rowIndex,
      selectedEventIds: selectedEventIds,
      setCellProps: cveProps.setCellProps,
      showCheckboxes: showCheckboxes,
      onRuleChange: eventContext === null || eventContext === void 0 ? void 0 : eventContext.onRuleChange,
      tabType: 'query',
      tableId: tableId,
      width: 0,
      setEventsLoading: ({
        isLoading
      }) => {
        if (!isLoading) {
          clearSelection();
          return;
        }
        if (setIsActionLoading) setIsActionLoading(isLoading);
      },
      setEventsDeleted: () => {},
      refetch: alertsTableRefresh
    });
  }, [columnHeaders, loadingEventIds, showCheckboxes, leadingControlColumn, selectedEventIds, eventContext]);
  return {
    renderCustomActionsRow,
    width: leadingControlColumn.width
  };
};
exports.getUseActionColumnHook = getUseActionColumnHook;