"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSignalIndex = void 0;
var _react = require("react");
var _securitysolutionTGrid = require("@kbn/securitysolution-t-grid");
var _reactRedux = require("react-redux");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _api = require("./api");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_alerts_privileges = require("./use_alerts_privileges");
var _store = require("../../../../common/store");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook for managing signal index
 *
 *
 */
const useSignalIndex = () => {
  const [loading, setLoading] = (0, _react.useState)(true);
  const [signalIndex, setSignalIndex] = (0, _react.useState)({
    signalIndexExists: null,
    signalIndexName: null,
    signalIndexMappingOutdated: null,
    createDeSignalIndex: null
  });
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    hasIndexRead
  } = (0, _use_alerts_privileges.useAlertsPrivileges)();
  const signalIndexMappingOutdated = (0, _reactRedux.useSelector)(state => {
    return _store.sourcererSelectors.signalIndexMappingOutdated(state);
  });
  const signalIndexName = (0, _reactRedux.useSelector)(state => {
    return _store.sourcererSelectors.signalIndexName(state);
  });
  (0, _react.useEffect)(() => {
    let isSubscribed = true;
    const abortCtrl = new AbortController();
    const fetchData = async () => {
      try {
        setLoading(true);
        const signal = await (0, _api.getSignalIndex)({
          signal: abortCtrl.signal
        });
        if (isSubscribed && signal != null) {
          setSignalIndex({
            signalIndexExists: true,
            signalIndexName: signal.name,
            signalIndexMappingOutdated: signal.index_mapping_outdated,
            createDeSignalIndex: createIndex
          });
        }
      } catch (error) {
        if (isSubscribed) {
          setSignalIndex({
            signalIndexExists: false,
            signalIndexName: null,
            signalIndexMappingOutdated: null,
            createDeSignalIndex: createIndex
          });
          if ((0, _securitysolutionTGrid.isSecurityAppError)(error) && error.body.status_code !== 404) {
            addError(error, {
              title: i18n.SIGNAL_GET_NAME_FAILURE
            });
          }
        }
      }
      if (isSubscribed) {
        setLoading(false);
      }
    };
    const createIndex = async () => {
      let isFetchingData = false;
      try {
        setLoading(true);
        await (0, _api.createSignalIndex)({
          signal: abortCtrl.signal
        });
        if (isSubscribed) {
          isFetchingData = true;
          fetchData();
        }
      } catch (error) {
        if (isSubscribed) {
          if ((0, _securitysolutionTGrid.isSecurityAppError)(error) && error.body.status_code === 409) {
            fetchData();
          } else {
            setSignalIndex({
              signalIndexExists: false,
              signalIndexName: null,
              signalIndexMappingOutdated: null,
              createDeSignalIndex: createIndex
            });
            addError(error, {
              title: i18n.SIGNAL_POST_FAILURE
            });
          }
        }
      }
      if (isSubscribed && !isFetchingData) {
        setLoading(false);
      }
    };
    if (signalIndexName) {
      setSignalIndex({
        signalIndexExists: true,
        signalIndexName,
        signalIndexMappingOutdated,
        createDeSignalIndex: createIndex
      });
      setLoading(false);
    } else if (hasIndexRead) {
      fetchData();
    } else {
      // Skip data fetching as the current user doesn't have enough priviliges.
      // Attempt to get the signal index will result in 500 error.
      setLoading(false);
    }
    return () => {
      isSubscribed = false;
      abortCtrl.abort();
    };
  }, [addError, hasIndexRead, signalIndexName, signalIndexMappingOutdated]);
  return {
    loading,
    ...signalIndex
  };
};
exports.useSignalIndex = useSignalIndex;