"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRenderCellValueHook = exports.RenderCellValue = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _use_license = require("../../../common/hooks/use_license");
var _use_selector = require("../../../common/hooks/use_selector");
var _renderers = require("../../../timelines/components/timeline/body/renderers");
var _tour_step = require("../../../common/components/guided_onboarding_tour/tour_step");
var _helpers = require("../../../common/components/top_n/helpers");
var _tour_config = require("../../../common/components/guided_onboarding_tour/tour_config");
var _constants = require("../../../timelines/components/timeline/body/renderers/constants");
var _sourcerer = require("../../../common/containers/sourcerer");
var _default_cell_renderer = require("../../../timelines/components/timeline/cell_rendering/default_cell_renderer");
var _translations = require("./translations");
var _constants2 = require("../../../../common/constants");
var _source = require("../../../common/containers/source");
var _columns = require("./columns");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This implementation of `EuiDataGrid`'s `renderCellValue`
 * accepts `EuiDataGridCellValueElementProps`, plus `data`
 * from the TGrid
 */

const RenderCellValue = exports.RenderCellValue = /*#__PURE__*/(0, _react.memo)(function RenderCellValue(props) {
  var _useDeepEqualSelector;
  const {
    columnId,
    rowIndex,
    scopeId,
    tableId,
    header,
    data,
    ecsData,
    linkValues,
    rowRenderers,
    isDetails,
    isExpandable,
    isDraggable = false,
    isExpanded,
    colIndex,
    eventId,
    setCellProps,
    truncate,
    context
  } = props;
  const isTourAnchor = (0, _react.useMemo)(() => columnId === _constants.SIGNAL_RULE_NAME_FIELD_NAME && (0, _helpers.isDetectionsAlertsTable)(tableId) && rowIndex === 0 && !props.isDetails, [columnId, props.isDetails, rowIndex, tableId]);
  const {
    browserFields
  } = (0, _sourcerer.useSourcererDataView)(scopeId);
  const browserFieldsByName = (0, _react.useMemo)(() => (0, _source.getAllFieldsByName)(browserFields), [browserFields]);
  const getTable = (0, _react.useMemo)(() => _securitysolutionDataTable.dataTableSelectors.getTableByIdSelector(), []);
  const license = (0, _use_license.useLicense)();
  const viewMode = (_useDeepEqualSelector = (0, _use_selector.useDeepEqualSelector)(state => {
    var _getTable;
    return ((_getTable = getTable(state, tableId)) !== null && _getTable !== void 0 ? _getTable : _securitysolutionDataTable.tableDefaults).viewMode;
  })) !== null && _useDeepEqualSelector !== void 0 ? _useDeepEqualSelector : _securitysolutionDataTable.tableDefaults.viewMode;
  const gridColumns = (0, _react.useMemo)(() => {
    return (0, _columns.getColumns)(license);
  }, [license]);
  const columnHeaders = (0, _react.useMemo)(() => {
    return viewMode === _constants2.VIEW_SELECTION.gridView ? gridColumns : _columns.eventRenderedViewColumns;
  }, [gridColumns, viewMode]);

  /**
   * There is difference between how `triggers actions` fetched data v/s
   * how security solution fetches data via timelineSearchStrategy
   *
   * _id and _index fields are array in timelineSearchStrategy  but not in
   * ruleStrategy
   *
   *
   */

  const finalData = (0, _react.useMemo)(() => {
    return data.map(field => {
      if (['_id', '_index'].includes(field.field)) {
        var _field$value;
        const newValue = (_field$value = field.value) !== null && _field$value !== void 0 ? _field$value : '';
        return {
          field: field.field,
          value: Array.isArray(newValue) ? newValue : [newValue]
        };
      } else {
        return field;
      }
    });
  }, [data]);
  const actualSuppressionCount = (0, _react.useMemo)(() => {
    var _ecsData$kibana, _ecsData$kibana$alert, _ecsData$kibana$alert2, _find, _find$value;
    // We check both ecsData and data for the suppression count because it could be in either one,
    // depending on where RenderCellValue is being used - when used in cases, data is populated,
    // whereas in the regular security alerts table it's in ecsData
    const ecsSuppressionCount = ecsData === null || ecsData === void 0 ? void 0 : (_ecsData$kibana = ecsData.kibana) === null || _ecsData$kibana === void 0 ? void 0 : (_ecsData$kibana$alert = _ecsData$kibana.alert.suppression) === null || _ecsData$kibana$alert === void 0 ? void 0 : (_ecsData$kibana$alert2 = _ecsData$kibana$alert.docs_count) === null || _ecsData$kibana$alert2 === void 0 ? void 0 : _ecsData$kibana$alert2[0];
    const dataSuppressionCount = (_find = (0, _fp.find)({
      field: 'kibana.alert.suppression.docs_count'
    }, data)) === null || _find === void 0 ? void 0 : (_find$value = _find.value) === null || _find$value === void 0 ? void 0 : _find$value[0];
    return ecsSuppressionCount ? parseInt(ecsSuppressionCount, 10) : dataSuppressionCount;
  }, [ecsData, data]);
  const Renderer = (0, _react.useMemo)(() => {
    var _colHeader$linkField;
    const myHeader = header !== null && header !== void 0 ? header : {
      id: columnId,
      ...browserFieldsByName[columnId]
    };
    const colHeader = columnHeaders.find(col => col.id === columnId);
    const localLinkValues = (0, _fp.getOr)([], (_colHeader$linkField = colHeader === null || colHeader === void 0 ? void 0 : colHeader.linkField) !== null && _colHeader$linkField !== void 0 ? _colHeader$linkField : '', ecsData);
    return /*#__PURE__*/_react.default.createElement(_tour_step.GuidedOnboardingTourStep, {
      isTourAnchor: isTourAnchor,
      step: _tour_config.AlertsCasesTourSteps.pointToAlertName,
      tourId: _tour_config.SecurityStepId.alertsCases
    }, /*#__PURE__*/_react.default.createElement(_default_cell_renderer.DefaultCellRenderer, {
      browserFields: browserFields,
      columnId: columnId,
      data: finalData,
      ecsData: ecsData,
      eventId: eventId,
      header: myHeader,
      isDetails: isDetails,
      isDraggable: isDraggable,
      isExpandable: isExpandable,
      isExpanded: isExpanded,
      linkValues: linkValues !== null && linkValues !== void 0 ? linkValues : localLinkValues,
      rowIndex: rowIndex,
      colIndex: colIndex,
      rowRenderers: rowRenderers !== null && rowRenderers !== void 0 ? rowRenderers : _renderers.defaultRowRenderers,
      setCellProps: setCellProps,
      scopeId: tableId,
      truncate: truncate,
      asPlainText: false,
      context: context
    }));
  }, [isTourAnchor, finalData, browserFieldsByName, header, columnId, ecsData, linkValues, rowRenderers, isDetails, isExpandable, isDraggable, isExpanded, colIndex, eventId, setCellProps, truncate, context, tableId, browserFields, rowIndex, columnHeaders]);
  return columnId === _constants.SIGNAL_RULE_NAME_FIELD_NAME && actualSuppressionCount ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: (0, _translations.SUPPRESSED_ALERT_TOOLTIP)(actualSuppressionCount)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "layers"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, Renderer)) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, Renderer);
});
const getRenderCellValueHook = ({
  scopeId,
  tableId
}) => {
  const useRenderCellValue = props => {
    return /*#__PURE__*/_react.default.createElement(RenderCellValue, (0, _extends2.default)({}, props, {
      scopeId: scopeId,
      tableId: tableId
    }));
  };
  return useRenderCellValue;
};
exports.getRenderCellValueHook = getRenderCellValueHook;