"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.columns = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _default_headers = require("../../../../timelines/components/timeline/body/column_headers/default_headers");
var _constants = require("../../../../timelines/components/timeline/body/constants");
var i18n = _interopRequireWildcard(require("../../../components/alerts_table/translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * columns implements a subset of `EuiDataGrid`'s `EuiDataGridColumn` interface,
 * plus additional TGrid column properties
 */
const columns = exports.columns = [{
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  displayAsText: i18n.STATUS,
  id: _ruleDataUtils.ALERT_STATUS,
  initialWidth: 74
}, {
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  displayAsText: i18n.TRIGGERED,
  id: '@timestamp',
  initialWidth: _constants.DEFAULT_DATE_COLUMN_MIN_WIDTH + 5
}, {
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  displayAsText: i18n.ALERT_DURATION,
  id: _ruleDataUtils.ALERT_DURATION,
  initialWidth: 116
}, {
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  displayAsText: i18n.ALERTS_HEADERS_SEVERITY,
  id: 'signal.rule.severity',
  initialWidth: 102
}, {
  columnHeaderType: _default_headers.defaultColumnHeaderType,
  displayAsText: i18n.ALERTS_HEADERS_REASON,
  id: _ruleDataUtils.ALERT_REASON
}];