"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Severity = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SeverityBadge = (0, _styledComponents.default)(_eui.EuiBadge)`
  align-items: center;
  display: inline-flex;
  height: 40px;
  text-transform: capitalize;
`;
const getBadgeColorFromSeverity = severity => {
  switch (`${severity}`.toLowerCase()) {
    case 'low':
      return '#C5CFD8';
    case 'medium':
      return '#EFC44C';
    case 'high':
      return '#FF7E62';
    case 'critical':
      return '#C3505E';
    default:
      return 'hollow';
  }
};
const getTextColorFromSeverity = severity => {
  switch (`${severity}`.toLowerCase()) {
    case 'critical': // fall through
    case 'high':
      return 'ghost';
    default:
      return 'default';
  }
};
const SeverityComponent = ({
  severity
}) => /*#__PURE__*/_react.default.createElement(SeverityBadge, {
  color: getBadgeColorFromSeverity(severity),
  "data-test-subj": "severity-badge"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: getTextColorFromSeverity(severity),
  "data-test-subj": "severity-text",
  size: "xs"
}, severity));
const Severity = exports.Severity = /*#__PURE__*/_react.default.memo(SeverityComponent);