"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRelatedIntegrations = void 0;
var _react = require("react");
var _integration_details = require("./integration_details");
var _use_installed_integrations = require("./use_installed_integrations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useRelatedIntegrations = relatedIntegrations => {
  const {
    data: installedIntegrations
  } = (0, _use_installed_integrations.useInstalledIntegrations)({
    packages: []
  });
  return (0, _react.useMemo)(() => {
    const integrationDetails = (0, _integration_details.calculateIntegrationDetails)(relatedIntegrations, installedIntegrations);
    return {
      integrations: integrationDetails,
      isLoaded: installedIntegrations != null
    };
  }, [relatedIntegrations, installedIntegrations]);
};
exports.useRelatedIntegrations = useRelatedIntegrations;