"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrePackagedRulesPrompt = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _user_info = require("../../user_info");
var _add_elastic_rules_button = require("./add_elastic_rules_button");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EmptyPrompt = (0, _styledComponents.default)(_eui.EuiEmptyPrompt)`
  align-self: center; /* Corrects horizontal centering in IE11 */
`;
EmptyPrompt.displayName = 'EmptyPrompt';
const PrePackagedRulesPromptComponent = () => {
  const [{
    loading,
    canUserCRUD
  }] = (0, _user_info.useUserData)();
  return /*#__PURE__*/_react.default.createElement(EmptyPrompt, {
    "data-test-subj": "rulesEmptyPrompt",
    title: /*#__PURE__*/_react.default.createElement("h2", null, i18n.PRE_BUILT_TITLE),
    body: /*#__PURE__*/_react.default.createElement("p", null, i18n.PRE_BUILT_MSG),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_add_elastic_rules_button.AddElasticRulesButton, {
      isDisabled: !canUserCRUD || loading,
      fill: true,
      "data-test-subj": "add-elastc-rules-empty-empty-prompt-button",
      showBadge: false
    })))
  });
};
const PrePackagedRulesPrompt = exports.PrePackagedRulesPrompt = /*#__PURE__*/(0, _react.memo)(PrePackagedRulesPromptComponent);