"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetSentinelOneAgentStatus = void 0;
var _reactQuery = require("@tanstack/react-query");
var _constants = require("../../../../common/endpoint/constants");
var _kibana = require("../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetSentinelOneAgentStatus = (agentIds, options = {}) => {
  const http = (0, _kibana.useHttp)();
  return (0, _reactQuery.useQuery)({
    queryKey: ['get-agent-status', agentIds],
    ...options,
    // TODO: update this to use a function instead of a number
    refetchInterval: 2000,
    queryFn: () => http.get(_constants.ENDPOINT_AGENT_STATUS_ROUTE, {
      version: '1',
      query: {
        agentIds,
        // 8.13 sentinel_one support via internal API
        agentType: 'sentinel_one'
      }
    }).then(response => response.data)
  });
};
exports.useGetSentinelOneAgentStatus = useGetSentinelOneAgentStatus;