"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnisolateHost = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _translations = require("./translations");
var _host_isolation = require("../../../common/components/endpoint/host_isolation");
var _use_host_unisolation = require("../../containers/detection_engine/alerts/use_host_unisolation");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UnisolateHost = exports.UnisolateHost = /*#__PURE__*/_react.default.memo(({
  endpointId,
  hostName,
  casesInfo,
  agentType,
  cancelCallback,
  successCallback
}) => {
  const [comment, setComment] = (0, _react.useState)('');
  const [isUnIsolated, setIsUnIsolated] = (0, _react.useState)(false);
  const caseIds = casesInfo.map(caseInfo => {
    return caseInfo.id;
  });
  const {
    loading,
    unIsolateHost
  } = (0, _use_host_unisolation.useHostUnisolation)({
    endpointId,
    comment,
    caseIds,
    agentType
  });
  const confirmHostUnIsolation = (0, _react.useCallback)(async () => {
    const hostUnIsolated = await unIsolateHost();
    setIsUnIsolated(hostUnIsolated);
    if (hostUnIsolated && successCallback) {
      successCallback();
    }
  }, [successCallback, unIsolateHost]);
  const backToAlertDetails = (0, _react.useCallback)(() => cancelCallback(), [cancelCallback]);
  const handleIsolateFormChange = (0, _react.useCallback)(({
    comment: newComment
  }) => setComment(newComment), []);
  const caseCount = (0, _react.useMemo)(() => casesInfo.length, [casesInfo]);
  const hostUnisolatedSuccessButton = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_host_isolation.ActionCompletionReturnButton, {
      onClick: backToAlertDetails,
      buttonText: _translations.RETURN_TO_ALERT_DETAILS
    });
  }, [backToAlertDetails]);
  const hostNotUnisolated = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_host_isolation.EndpointUnisolateForm, {
      hostName: hostName,
      onCancel: backToAlertDetails,
      onConfirm: confirmHostUnIsolation,
      onChange: handleIsolateFormChange,
      comment: comment,
      isLoading: loading,
      messageAppend: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.detections.hostIsolation.impactedCases",
        defaultMessage: "This action will be added to {cases}.",
        values: {
          cases: /*#__PURE__*/_react.default.createElement("b", null, (0, _translations.CASES_ASSOCIATED_WITH_ALERT)(caseCount))
        }
      })
    }));
  }, [hostName, backToAlertDetails, confirmHostUnIsolation, handleIsolateFormChange, comment, loading, caseCount]);
  return isUnIsolated ? hostUnisolatedSuccessButton : hostNotUnisolated;
});
UnisolateHost.displayName = 'UnisolateHost';