"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SentinelOneAgentStatus = exports.SENTINEL_ONE_NETWORK_STATUS = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
var _agent_status_text = require("../../../common/components/endpoint/agent_status_text");
var _host_constants = require("../../../management/pages/endpoint_hosts/view/host_constants");
var _use_sentinelone_host_isolation = require("./use_sentinelone_host_isolation");
var _endpoint_agent_status = require("../../../common/components/endpoint/endpoint_agent_status");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let SENTINEL_ONE_NETWORK_STATUS = exports.SENTINEL_ONE_NETWORK_STATUS = /*#__PURE__*/function (SENTINEL_ONE_NETWORK_STATUS) {
  SENTINEL_ONE_NETWORK_STATUS["CONNECTING"] = "connecting";
  SENTINEL_ONE_NETWORK_STATUS["CONNECTED"] = "connected";
  SENTINEL_ONE_NETWORK_STATUS["DISCONNECTING"] = "disconnecting";
  SENTINEL_ONE_NETWORK_STATUS["DISCONNECTED"] = "disconnected";
  return SENTINEL_ONE_NETWORK_STATUS;
}({});
const EuiFlexGroupStyled = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  .isolation-status {
    margin-left: ${({
  theme
}) => theme.eui.euiSizeS};
  }
`;
const SentinelOneAgentStatus = exports.SentinelOneAgentStatus = /*#__PURE__*/_react.default.memo(({
  agentId,
  'data-test-subj': dataTestSubj
}) => {
  const sentinelOneManualHostActionsEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('sentinelOneManualHostActionsEnabled');
  const {
    data,
    isLoading,
    isFetched
  } = (0, _use_sentinelone_host_isolation.useGetSentinelOneAgentStatus)([agentId], {
    enabled: sentinelOneManualHostActionsEnabled
  });
  const agentStatus = data === null || data === void 0 ? void 0 : data[`${agentId}`];
  const label = (0, _react.useMemo)(() => {
    const currentNetworkStatus = agentStatus === null || agentStatus === void 0 ? void 0 : agentStatus.isolated;
    const pendingActions = agentStatus === null || agentStatus === void 0 ? void 0 : agentStatus.pendingActions;
    if (pendingActions) {
      if (pendingActions.isolate > 0) {
        return _endpoint_agent_status.ISOLATING_LABEL;
      }
      if (pendingActions.unisolate > 0) {
        return _endpoint_agent_status.RELEASING_LABEL;
      }
    }
    if (currentNetworkStatus) {
      return _endpoint_agent_status.ISOLATED_LABEL;
    }
  }, [agentStatus === null || agentStatus === void 0 ? void 0 : agentStatus.isolated, agentStatus === null || agentStatus === void 0 ? void 0 : agentStatus.pendingActions]);
  return /*#__PURE__*/_react.default.createElement(EuiFlexGroupStyled, {
    gutterSize: "none",
    responsive: false,
    className: "eui-textTruncate",
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, isFetched && !isLoading && agentStatus ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: _host_constants.HOST_STATUS_TO_BADGE_COLOR[agentStatus.status],
    className: "eui-textTruncate"
  }, (0, _agent_status_text.getAgentStatusText)(agentStatus.status)) : '-'), isFetched && !isLoading && label && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "eui-textTruncate isolation-status"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, label))));
});
SentinelOneAgentStatus.displayName = 'SentinelOneAgentStatus';