"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResponderActionButton = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _use_responder_action_data = require("./use_responder_action_data");
var _user_privileges = require("../../../common/components/user_privileges");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ResponderActionButton = exports.ResponderActionButton = /*#__PURE__*/(0, _react.memo)(({
  endpointId,
  onClick
}) => {
  const {
    handleResponseActionsClick,
    isDisabled,
    tooltip
  } = (0, _use_responder_action_data.useResponderActionData)({
    endpointId,
    onClick
  });
  const endpointPrivileges = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  if (!endpointPrivileges.canAccessResponseConsole) {
    return null;
  }
  const actionButtonKey = 'endpointResponseActions-action-button';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: tooltip
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    key: actionButtonKey,
    "data-test-subj": actionButtonKey,
    disabled: isDisabled,
    onClick: handleResponseActionsClick
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.detections.takeAction.responseActionConsole.buttonLabel",
    defaultMessage: "Respond"
  })));
});
ResponderActionButton.displayName = 'ResponderActionButton';