"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSeverityTableColumns = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _draggables = require("../../../../common/components/draggables");
var _utils = require("../../../../overview/components/detection_response/utils");
var _formatted_number = require("../../../../common/components/formatted_number");
var _translations = require("../alerts_count_panel/translations");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSeverityTableColumns = () => [{
  field: 'key',
  name: i18n.SEVERITY_LEVEL_COLUMN_TITLE,
  'data-test-subj': 'severityTable-severity',
  render: severity => /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: _utils.SEVERITY_COLOR[severity],
    textSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
    isDraggable: false,
    field: _ruleDataUtils.ALERT_SEVERITY,
    hideTopN: true,
    id: `alert-severity-draggable-${severity}`,
    value: (0, _lodash.capitalize)(severity),
    queryValue: severity,
    tooltipContent: null
  }))
}, {
  field: 'value',
  name: _translations.COUNT_TABLE_TITLE,
  sortable: true,
  dataType: 'number',
  'data-test-subj': 'severityTable-alertCount',
  width: '45%',
  render: alertCount => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false,
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
    count: alertCount
  }))
}];
exports.getSeverityTableColumns = getSeverityTableColumns;