"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsHistogram = void 0;
var _i18n = require("@kbn/i18n");
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _common = require("../../../../common/components/charts/common");
var _utils = require("../../../../common/components/utils");
var _validators = require("../../../../common/utils/validators");
var _draggable_legend = require("../../../../common/components/charts/draggable_legend");
var _translation = require("../../../../common/components/charts/translation");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_CHART_HEIGHT = 174;
const AlertsHistogram = exports.AlertsHistogram = /*#__PURE__*/_react.default.memo(({
  chartHeight = DEFAULT_CHART_HEIGHT,
  data,
  from,
  legendItems,
  legendPosition = _charts.Position.Right,
  legendMinWidth,
  loading,
  showLegend,
  to,
  updateDateRange
}) => {
  const {
    baseTheme,
    theme
  } = (0, _common.useThemes)();
  const chartSize = (0, _react.useMemo)(() => ['100%', chartHeight], [chartHeight]);
  const xAxisId = 'alertsHistogramAxisX';
  const yAxisId = 'alertsHistogramAxisY';
  const id = 'alertsHistogram';
  const yAccessors = (0, _react.useMemo)(() => ['y'], []);
  const splitSeriesAccessors = (0, _react.useMemo)(() => [datum => (0, _validators.hasValueToDisplay)(datum.g) ? datum.g : _translation.EMPTY_VALUE_LABEL], []);
  const tickFormat = (0, _react.useMemo)(() => (0, _utils.histogramDateTimeFormatter)([from, to]), [from, to]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, loading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    "data-test-subj": "loadingPanelAlertsHistogram",
    size: "xs",
    position: "absolute",
    color: "accent"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: chartSize
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    legendPosition: legendPosition,
    onBrushEnd: updateDateRange
    // showLegend controls the default legend coming from Elastic chart, we show them when our customised legend items doesn't exist (but we still want to show legend).
    ,
    showLegend: showLegend && legendItems.length === 0,
    showLegendExtra: showLegend,
    theme: theme,
    baseTheme: baseTheme,
    locale: _i18n.i18n.getLocale()
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: xAxisId,
    position: _charts.Position.Bottom,
    tickFormat: tickFormat
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: yAxisId,
    position: _charts.Position.Left
  }), /*#__PURE__*/_react.default.createElement(_charts.HistogramBarSeries, {
    id: id,
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "x",
    yAccessors: yAccessors,
    stackAccessors: ['true'],
    splitSeriesAccessors: splitSeriesAccessors,
    data: data
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, legendItems.length > 0 && /*#__PURE__*/_react.default.createElement(_draggable_legend.DraggableLegend, {
    legendItems: legendItems,
    height: chartHeight,
    minWidth: legendMinWidth
  }))));
});
AlertsHistogram.displayName = 'AlertsHistogram';