"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DETECTIONS_ALERTS_COUNT_ID = exports.AlertsCountPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _header_section = require("../../../../common/components/header_section");
var _inspect = require("../../../../common/components/inspect");
var i18n = _interopRequireWildcard(require("./translations"));
var _components = require("../common/components");
var _query_toggle = require("../../../../common/containers/query_toggle");
var _field_selection = require("../../../../common/components/field_selection");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _alerts_table = require("../../../../common/components/visualization_actions/lens_attributes/common/alerts/alerts_table");
var _model = require("../../../../common/store/sourcerer/model");
var _visualization_embeddable = require("../../../../common/components/visualization_actions/visualization_embeddable");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DETECTIONS_ALERTS_COUNT_ID = exports.DETECTIONS_ALERTS_COUNT_ID = 'detections-alerts-count';
const CHART_HEIGHT = 218; // px

const AlertsCountPanel = exports.AlertsCountPanel = /*#__PURE__*/(0, _react.memo)(({
  alignHeader,
  chartOptionsContextMenu,
  extraActions,
  filters,
  inspectTitle,
  panelHeight,
  setStackByField0,
  setStackByField0ComboboxInputRef,
  setStackByField1,
  setStackByField1ComboboxInputRef,
  stackByField0,
  stackByField0ComboboxRef,
  stackByField1,
  stackByField1ComboboxRef,
  stackByWidth,
  title = i18n.COUNT_TABLE_TITLE,
  isExpanded,
  setIsExpanded
}) => {
  const {
    to,
    from
  } = (0, _use_global_time.useGlobalTime)();
  const isAlertsPageChartsEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('alertsPageChartsEnabled');
  // create a unique, but stable (across re-renders) query id
  const uniqueQueryId = (0, _react.useMemo)(() => `${DETECTIONS_ALERTS_COUNT_ID}-${(0, _uuid.v4)()}`, []);
  const {
    toggleStatus,
    setToggleStatus
  } = (0, _query_toggle.useQueryToggle)(DETECTIONS_ALERTS_COUNT_ID);
  const toggleQuery = (0, _react.useCallback)(newToggleStatus => {
    if (isAlertsPageChartsEnabled && setIsExpanded) {
      setIsExpanded(newToggleStatus);
    } else {
      setToggleStatus(newToggleStatus);
    }
  }, [setToggleStatus, setIsExpanded, isAlertsPageChartsEnabled]);
  const timerange = (0, _react.useMemo)(() => ({
    from,
    to
  }), [from, to]);
  const extraVisualizationOptions = (0, _react.useMemo)(() => ({
    breakdownField: stackByField1,
    filters
  }), [filters, stackByField1]);
  const showCount = (0, _react.useMemo)(() => {
    if (isAlertsPageChartsEnabled) {
      return isExpanded;
    }
    return toggleStatus;
  }, [isAlertsPageChartsEnabled, toggleStatus, isExpanded]);
  return /*#__PURE__*/_react.default.createElement(_inspect.InspectButtonContainer, {
    show: isAlertsPageChartsEnabled ? isExpanded : toggleStatus
  }, /*#__PURE__*/_react.default.createElement(_components.KpiPanel, {
    $toggleStatus: isAlertsPageChartsEnabled && isExpanded !== undefined ? isExpanded : toggleStatus,
    "data-test-subj": "alertsCountPanel",
    hasBorder: true,
    height: panelHeight
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    alignHeader: alignHeader,
    id: uniqueQueryId,
    inspectTitle: inspectTitle,
    outerDirection: "row",
    title: title,
    titleSize: "s",
    hideSubtitle: true,
    showInspectButton: chartOptionsContextMenu == null,
    toggleStatus: isAlertsPageChartsEnabled ? isExpanded : toggleStatus,
    toggleQuery: toggleQuery
  }, /*#__PURE__*/_react.default.createElement(_field_selection.FieldSelection, {
    setStackByField0: setStackByField0,
    setStackByField0ComboboxInputRef: setStackByField0ComboboxInputRef,
    setStackByField1: setStackByField1,
    setStackByField1ComboboxInputRef: setStackByField1ComboboxInputRef,
    stackByField0: stackByField0,
    stackByField0ComboboxRef: stackByField0ComboboxRef,
    stackByField1: stackByField1,
    stackByField1ComboboxRef: stackByField1ComboboxRef,
    stackByWidth: stackByWidth,
    uniqueQueryId: uniqueQueryId,
    useLensCompatibleFields: true
  })), showCount && /*#__PURE__*/_react.default.createElement(_visualization_embeddable.VisualizationEmbeddable, {
    "data-test-subj": "embeddable-alerts-count",
    extraActions: extraActions,
    extraOptions: extraVisualizationOptions,
    getLensAttributes: _alerts_table.getAlertsTableLensAttributes,
    height: CHART_HEIGHT,
    id: `${uniqueQueryId}-embeddable`,
    inspectTitle: inspectTitle,
    scopeId: _model.SourcererScopeName.detections,
    stackByField: stackByField0,
    timerange: timerange
  })));
});
AlertsCountPanel.displayName = 'AlertsCountPanel';