"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertsCountQuery = exports.DEFAULT_STACK_BY_FIELD1_SIZE = exports.DEFAULT_STACK_BY_FIELD0_SIZE = void 0;
var _query = require("../../../../common/components/alerts_treemap/query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_STACK_BY_FIELD0_SIZE = exports.DEFAULT_STACK_BY_FIELD0_SIZE = 1000;
const DEFAULT_STACK_BY_FIELD1_SIZE = exports.DEFAULT_STACK_BY_FIELD1_SIZE = 1000;
const getAlertsCountQuery = ({
  additionalFilters = [],
  from,
  runtimeMappings,
  stackByField0,
  stackByField1,
  to
}) => {
  return {
    size: 0,
    aggs: {
      stackByField0: {
        terms: {
          field: stackByField0,
          order: {
            _count: 'desc'
          },
          size: DEFAULT_STACK_BY_FIELD0_SIZE
        },
        aggs: {
          ...(0, _query.getOptionalSubAggregation)({
            stackByField1,
            stackByField1Size: DEFAULT_STACK_BY_FIELD1_SIZE
          })
        }
      }
    },
    query: {
      bool: {
        filter: [...additionalFilters, {
          range: {
            '@timestamp': {
              gte: from,
              lte: to
            }
          }
        }]
      }
    },
    runtime_mappings: runtimeMappings
  };
};
exports.getAlertsCountQuery = getAlertsCountQuery;