"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.populateSelected = exports.getCardBackgroundColor = exports.extractSelected = void 0;
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCardBackgroundColor = value => {
  for (const {
    threshold,
    color
  } of _constants.coverageOverviewCardColorThresholds) {
    if (value >= threshold) {
      return color;
    }
  }
};
exports.getCardBackgroundColor = getCardBackgroundColor;
const extractSelected = options => {
  return options.filter(option => option.checked === 'on').map(option => option.label);
};
exports.extractSelected = extractSelected;
const populateSelected = (allOptions, selected) => allOptions.map(option => selected.includes(option.label) ? {
  ...option,
  checked: 'on'
} : option);
exports.populateSelected = populateSelected;