"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBulkActions = void 0;
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _uiTheme = require("@kbn/ui-theme");
var _react = _interopRequireWildcard(require("react"));
var _rule_filtering = require("../../../../../../common/detection_engine/rule_management/rule_filtering");
var _constants = require("../../../../../../common/detection_engine/rule_management/constants");
var _rule_management = require("../../../../../../common/api/detection_engine/rule_management");
var _helpers = require("../../../../../../common/machine_learning/helpers");
var _use_app_toasts = require("../../../../../common/hooks/use_app_toasts");
var _user_actions = require("../../../../../common/lib/apm/user_actions");
var _use_start_transaction = require("../../../../../common/lib/apm/use_start_transaction");
var _privileges = require("../../../../../common/utils/privileges");
var i18n = _interopRequireWildcard(require("../../../../../detections/pages/detection_engine/rules/translations"));
var detectionI18n = _interopRequireWildcard(require("../../../../../detections/pages/detection_engine/translations"));
var _use_bulk_export = require("../../../../rule_management/logic/bulk_actions/use_bulk_export");
var _use_execute_bulk_action = require("../../../../rule_management/logic/bulk_actions/use_execute_bulk_action");
var _use_download_exported_rules = require("../../../../rule_management/logic/bulk_actions/use_download_exported_rules");
var _helpers2 = require("../helpers");
var _rules_table_context = require("../rules_table/rules_table_context");
var _use_has_actions_privileges = require("../use_has_actions_privileges");
var _use_has_ml_permissions = require("../use_has_ml_permissions");
var _compute_dry_run_edit_payload = require("./utils/compute_dry_run_edit_payload");
var _dry_run_result = require("./utils/dry_run_result");
var _prepare_search_params = require("./utils/prepare_search_params");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/* eslint-disable complexity */

const useBulkActions = ({
  filterOptions,
  confirmDeletion,
  showBulkActionConfirmation,
  showBulkDuplicateConfirmation,
  completeBulkEditForm,
  executeBulkActionsDryRun
}) => {
  const hasMlPermissions = (0, _use_has_ml_permissions.useHasMlPermissions)();
  const rulesTableContext = (0, _rules_table_context.useRulesTableContext)();
  const hasActionsPrivileges = (0, _use_has_actions_privileges.useHasActionsPrivileges)();
  const toasts = (0, _use_app_toasts.useAppToasts)();
  const kql = (0, _rule_filtering.convertRulesFilterToKQL)(filterOptions);
  const {
    startTransaction
  } = (0, _use_start_transaction.useStartTransaction)();
  const {
    executeBulkAction
  } = (0, _use_execute_bulk_action.useExecuteBulkAction)();
  const {
    bulkExport
  } = (0, _use_bulk_export.useBulkExport)();
  const downloadExportedRules = (0, _use_download_exported_rules.useDownloadExportedRules)();
  const {
    state: {
      isAllSelected,
      rules,
      loadingRuleIds,
      selectedRuleIds
    },
    actions: {
      clearRulesSelection,
      setIsPreflightInProgress
    }
  } = rulesTableContext;
  const getBulkItemsPopoverContent = (0, _react.useCallback)(closePopover => {
    const selectedRules = rules.filter(({
      id
    }) => selectedRuleIds.includes(id));
    const containsEnabled = selectedRules.some(({
      enabled
    }) => enabled);
    const containsDisabled = selectedRules.some(({
      enabled
    }) => !enabled);
    const containsLoading = selectedRuleIds.some(id => loadingRuleIds.includes(id));
    const missingActionPrivileges = !hasActionsPrivileges && selectedRules.some(rule => !(0, _privileges.canEditRuleWithActions)(rule, hasActionsPrivileges));
    const handleEnableAction = async () => {
      startTransaction({
        name: _user_actions.BULK_RULE_ACTIONS.ENABLE
      });
      closePopover();
      const disabledRules = selectedRules.filter(({
        enabled
      }) => !enabled);
      const disabledRulesNoML = disabledRules.filter(({
        type
      }) => !(0, _helpers.isMlRule)(type));
      const mlRuleCount = disabledRules.length - disabledRulesNoML.length;
      if (!hasMlPermissions && mlRuleCount > 0) {
        toasts.addWarning(detectionI18n.ML_RULES_UNAVAILABLE(mlRuleCount));
      }
      const ruleIds = hasMlPermissions ? disabledRules.map(({
        id
      }) => id) : disabledRulesNoML.map(({
        id
      }) => id);
      await executeBulkAction({
        type: _rule_management.BulkActionTypeEnum.enable,
        ...(isAllSelected ? {
          query: kql
        } : {
          ids: ruleIds
        })
      });
    };
    const handleDisableActions = async () => {
      startTransaction({
        name: _user_actions.BULK_RULE_ACTIONS.DISABLE
      });
      closePopover();
      const enabledIds = selectedRules.filter(({
        enabled
      }) => enabled).map(({
        id
      }) => id);
      await executeBulkAction({
        type: _rule_management.BulkActionTypeEnum.disable,
        ...(isAllSelected ? {
          query: kql
        } : {
          ids: enabledIds
        })
      });
    };
    const handleDuplicateAction = async () => {
      startTransaction({
        name: _user_actions.BULK_RULE_ACTIONS.DUPLICATE
      });
      closePopover();
      const modalDuplicationConfirmationResult = await showBulkDuplicateConfirmation();
      if (modalDuplicationConfirmationResult === null) {
        return;
      }
      await executeBulkAction({
        type: _rule_management.BulkActionTypeEnum.duplicate,
        duplicatePayload: {
          include_exceptions: modalDuplicationConfirmationResult === _constants.DuplicateOptions.withExceptions || modalDuplicationConfirmationResult === _constants.DuplicateOptions.withExceptionsExcludeExpiredExceptions,
          include_expired_exceptions: !(modalDuplicationConfirmationResult === _constants.DuplicateOptions.withExceptionsExcludeExpiredExceptions)
        },
        ...(isAllSelected ? {
          query: kql
        } : {
          ids: selectedRuleIds
        })
      });
      clearRulesSelection();
    };
    const handleDeleteAction = async () => {
      closePopover();
      if ((await confirmDeletion()) === false) {
        // User has canceled deletion
        return;
      }
      startTransaction({
        name: _user_actions.BULK_RULE_ACTIONS.DELETE
      });
      await executeBulkAction({
        type: _rule_management.BulkActionTypeEnum.delete,
        ...(isAllSelected ? {
          query: kql
        } : {
          ids: selectedRuleIds
        })
      });
    };
    const handleExportAction = async () => {
      closePopover();
      startTransaction({
        name: _user_actions.BULK_RULE_ACTIONS.EXPORT
      });
      const response = await bulkExport(isAllSelected ? {
        query: kql
      } : {
        ids: selectedRuleIds
      });

      // if response null, likely network error happened and export rules haven't been received
      if (!response) {
        return;
      }
      const details = await (0, _helpers2.getExportedRulesDetails)(response);

      // if there are failed exported rules, show modal window to users.
      // they can either cancel action or proceed with export of succeeded rules
      const hasActionBeenConfirmed = await showBulkActionConfirmation((0, _dry_run_result.transformExportDetailsToDryRunResult)(details), _rule_management.BulkActionTypeEnum.export);
      if (hasActionBeenConfirmed === false) {
        return;
      }
      await downloadExportedRules(response);
    };
    const handleBulkEdit = bulkEditActionType => async () => {
      let longTimeWarningToast;
      let isBulkEditFinished = false;
      closePopover();
      setIsPreflightInProgress(true);
      const dryRunResult = await executeBulkActionsDryRun({
        type: _rule_management.BulkActionTypeEnum.edit,
        ...(isAllSelected ? {
          query: (0, _rule_filtering.convertRulesFilterToKQL)(filterOptions)
        } : {
          ids: selectedRuleIds
        }),
        editPayload: (0, _compute_dry_run_edit_payload.computeDryRunEditPayload)(bulkEditActionType)
      });
      setIsPreflightInProgress(false);

      // User has cancelled edit action or there are no custom rules to proceed
      const hasActionBeenConfirmed = await showBulkActionConfirmation(dryRunResult, _rule_management.BulkActionTypeEnum.edit);
      if (hasActionBeenConfirmed === false) {
        return;
      }
      const editPayload = await completeBulkEditForm(bulkEditActionType);
      if (editPayload == null) {
        return;
      }
      startTransaction({
        name: _user_actions.BULK_RULE_ACTIONS.EDIT
      });
      const hideWarningToast = () => {
        if (longTimeWarningToast) {
          toasts.api.remove(longTimeWarningToast);
        }
      };

      // show warning toast only if bulk edit action exceeds 5s
      // if bulkAction already finished, we won't show toast at all (hence flag "isBulkEditFinished")
      setTimeout(() => {
        var _dryRunResult$succeed;
        if (isBulkEditFinished) {
          return;
        }
        longTimeWarningToast = toasts.addWarning({
          title: i18n.BULK_EDIT_WARNING_TOAST_TITLE,
          text: (0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, i18n.BULK_EDIT_WARNING_TOAST_DESCRIPTION((_dryRunResult$succeed = dryRunResult === null || dryRunResult === void 0 ? void 0 : dryRunResult.succeededRulesCount) !== null && _dryRunResult$succeed !== void 0 ? _dryRunResult$succeed : 0)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            justifyContent: "flexEnd",
            gutterSize: "s"
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
            color: "warning",
            size: "s",
            onClick: hideWarningToast
          }, i18n.BULK_EDIT_WARNING_TOAST_NOTIFY))))),
          iconType: undefined
        }, {
          toastLifeTimeMs: 10 * 60 * 1000
        });
      }, 5 * 1000);
      await executeBulkAction({
        type: _rule_management.BulkActionTypeEnum.edit,
        ...(0, _prepare_search_params.prepareSearchParams)({
          ...(isAllSelected ? {
            filterOptions
          } : {
            selectedRuleIds
          }),
          dryRunResult
        }),
        editPayload: [editPayload]
      });
      hideWarningToast();
      isBulkEditFinished = true;
    };
    const isDeleteDisabled = containsLoading || selectedRuleIds.length === 0;
    const isEditDisabled = missingActionPrivileges || containsLoading || selectedRuleIds.length === 0;
    return [{
      id: 0,
      title: i18n.BULK_ACTION_MENU_TITLE,
      items: [{
        key: i18n.BULK_ACTION_ENABLE,
        name: i18n.BULK_ACTION_ENABLE,
        'data-test-subj': 'enableRuleBulk',
        disabled: missingActionPrivileges || containsLoading || !containsDisabled && !isAllSelected,
        onClick: handleEnableAction,
        toolTipContent: missingActionPrivileges ? i18n.LACK_OF_KIBANA_ACTIONS_FEATURE_PRIVILEGES : undefined,
        toolTipProps: {
          position: 'right'
        },
        icon: undefined
      }, {
        key: i18n.BULK_ACTION_DUPLICATE,
        name: i18n.BULK_ACTION_DUPLICATE,
        'data-test-subj': 'duplicateRuleBulk',
        disabled: isEditDisabled,
        onClick: handleDuplicateAction,
        toolTipContent: missingActionPrivileges ? i18n.LACK_OF_KIBANA_ACTIONS_FEATURE_PRIVILEGES : undefined,
        toolTipProps: {
          position: 'right'
        },
        icon: undefined
      }, {
        key: i18n.BULK_ACTION_INDEX_PATTERNS,
        name: i18n.BULK_ACTION_INDEX_PATTERNS,
        'data-test-subj': 'indexPatternsBulkEditRule',
        disabled: isEditDisabled,
        panel: 2
      }, {
        key: i18n.BULK_ACTION_TAGS,
        name: i18n.BULK_ACTION_TAGS,
        'data-test-subj': 'tagsBulkEditRule',
        disabled: isEditDisabled,
        panel: 1
      }, {
        key: i18n.BULK_ACTION_ADD_RULE_ACTIONS,
        name: i18n.BULK_ACTION_ADD_RULE_ACTIONS,
        'data-test-subj': 'addRuleActionsBulk',
        disabled: !hasActionsPrivileges || isEditDisabled,
        onClick: handleBulkEdit(_rule_management.BulkActionEditTypeEnum.add_rule_actions),
        toolTipContent: !hasActionsPrivileges ? i18n.LACK_OF_KIBANA_ACTIONS_FEATURE_PRIVILEGES : undefined,
        toolTipProps: {
          position: 'right'
        },
        icon: undefined
      }, {
        key: i18n.BULK_ACTION_SET_SCHEDULE,
        name: i18n.BULK_ACTION_SET_SCHEDULE,
        'data-test-subj': 'setScheduleBulk',
        disabled: isEditDisabled,
        onClick: handleBulkEdit(_rule_management.BulkActionEditTypeEnum.set_schedule),
        toolTipContent: missingActionPrivileges ? i18n.LACK_OF_KIBANA_ACTIONS_FEATURE_PRIVILEGES : undefined,
        toolTipProps: {
          position: 'right'
        },
        icon: undefined
      }, {
        key: i18n.BULK_ACTION_APPLY_TIMELINE_TEMPLATE,
        name: i18n.BULK_ACTION_APPLY_TIMELINE_TEMPLATE,
        'data-test-subj': 'applyTimelineTemplateBulk',
        disabled: isEditDisabled,
        onClick: handleBulkEdit(_rule_management.BulkActionEditTypeEnum.set_timeline),
        toolTipContent: missingActionPrivileges ? i18n.LACK_OF_KIBANA_ACTIONS_FEATURE_PRIVILEGES : undefined,
        toolTipProps: {
          position: 'right'
        },
        icon: undefined
      }, {
        key: i18n.BULK_ACTION_EXPORT,
        name: i18n.BULK_ACTION_EXPORT,
        'data-test-subj': 'exportRuleBulk',
        disabled: containsLoading || selectedRuleIds.length === 0,
        onClick: handleExportAction,
        icon: undefined
      }, {
        key: i18n.BULK_ACTION_DISABLE,
        name: i18n.BULK_ACTION_DISABLE,
        'data-test-subj': 'disableRuleBulk',
        disabled: missingActionPrivileges || containsLoading || !containsEnabled && !isAllSelected,
        onClick: handleDisableActions,
        toolTipContent: missingActionPrivileges ? i18n.LACK_OF_KIBANA_ACTIONS_FEATURE_PRIVILEGES : undefined,
        toolTipProps: {
          position: 'right'
        },
        icon: undefined
      }, {
        key: i18n.BULK_ACTION_DELETE,
        name: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
          color: isDeleteDisabled ? _uiTheme.euiThemeVars.euiButtonColorDisabledText : 'danger'
        }, i18n.BULK_ACTION_DELETE),
        'data-test-subj': 'deleteRuleBulk',
        disabled: isDeleteDisabled,
        onClick: handleDeleteAction,
        toolTipProps: {
          position: 'right'
        },
        icon: undefined
      }]
    }, {
      id: 1,
      title: i18n.BULK_ACTION_MENU_TITLE,
      items: [{
        key: i18n.BULK_ACTION_ADD_TAGS,
        name: i18n.BULK_ACTION_ADD_TAGS,
        'data-test-subj': 'addTagsBulkEditRule',
        onClick: handleBulkEdit(_rule_management.BulkActionEditTypeEnum.add_tags),
        disabled: isEditDisabled,
        toolTipContent: missingActionPrivileges ? i18n.LACK_OF_KIBANA_ACTIONS_FEATURE_PRIVILEGES : undefined,
        toolTipProps: {
          position: 'right'
        }
      }, {
        key: i18n.BULK_ACTION_DELETE_TAGS,
        name: i18n.BULK_ACTION_DELETE_TAGS,
        'data-test-subj': 'deleteTagsBulkEditRule',
        onClick: handleBulkEdit(_rule_management.BulkActionEditTypeEnum.delete_tags),
        disabled: isEditDisabled,
        toolTipContent: missingActionPrivileges ? i18n.LACK_OF_KIBANA_ACTIONS_FEATURE_PRIVILEGES : undefined,
        toolTipProps: {
          position: 'right'
        }
      }]
    }, {
      id: 2,
      title: i18n.BULK_ACTION_MENU_TITLE,
      items: [{
        key: i18n.BULK_ACTION_ADD_INDEX_PATTERNS,
        name: i18n.BULK_ACTION_ADD_INDEX_PATTERNS,
        'data-test-subj': 'addIndexPatternsBulkEditRule',
        onClick: handleBulkEdit(_rule_management.BulkActionEditTypeEnum.add_index_patterns),
        disabled: isEditDisabled,
        toolTipContent: missingActionPrivileges ? i18n.LACK_OF_KIBANA_ACTIONS_FEATURE_PRIVILEGES : undefined,
        toolTipProps: {
          position: 'right'
        }
      }, {
        key: i18n.BULK_ACTION_DELETE_INDEX_PATTERNS,
        name: i18n.BULK_ACTION_DELETE_INDEX_PATTERNS,
        'data-test-subj': 'deleteIndexPatternsBulkEditRule',
        onClick: handleBulkEdit(_rule_management.BulkActionEditTypeEnum.delete_index_patterns),
        disabled: isEditDisabled,
        toolTipContent: missingActionPrivileges ? i18n.LACK_OF_KIBANA_ACTIONS_FEATURE_PRIVILEGES : undefined,
        toolTipProps: {
          position: 'right'
        }
      }]
    }];
  }, [rules, selectedRuleIds, hasActionsPrivileges, isAllSelected, loadingRuleIds, startTransaction, hasMlPermissions, executeBulkAction, kql, toasts, showBulkDuplicateConfirmation, clearRulesSelection, confirmDeletion, bulkExport, showBulkActionConfirmation, downloadExportedRules, setIsPreflightInProgress, executeBulkActionsDryRun, filterOptions, completeBulkEditForm]);
  return getBulkItemsPopoverContent;
};
exports.useBulkActions = useBulkActions;