"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesPageTourComponent = void 0;
var _eui = require("@elastic/eui");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _react = _interopRequireWildcard(require("react"));
var _siem_guide_config = require("../../../../../../common/guided_onboarding/siem_guide_config");
var _constants = require("../../../../../../common/constants");
var _kibana = require("../../../../../common/lib/kibana");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RulesPageTourComponent = ({
  children
}) => {
  var _guidedOnboarding$gui, _guidedOnboarding$gui2;
  const tourConfig = {
    currentTourStep: 1,
    isTourActive: true,
    tourPopoverWidth: 300
  };
  const {
    storage,
    guidedOnboarding
  } = (0, _kibana.useKibana)().services;
  const isGuidedOnboardingActive = (0, _useObservable.default)((_guidedOnboarding$gui = guidedOnboarding === null || guidedOnboarding === void 0 ? void 0 : (_guidedOnboarding$gui2 = guidedOnboarding.guidedOnboardingApi) === null || _guidedOnboarding$gui2 === void 0 ? void 0 : _guidedOnboarding$gui2.isGuideStepActive$(_siem_guide_config.siemGuideId, 'rules')) !== null && _guidedOnboarding$gui !== void 0 ? _guidedOnboarding$gui : (0, _rxjs.of)(false), true);
  const [tourState, setTourState] = (0, _react.useState)(() => {
    const restoredTourState = storage.get(_constants.NEW_FEATURES_TOUR_STORAGE_KEYS.RULE_MANAGEMENT_PAGE);
    if (restoredTourState != null) {
      return restoredTourState;
    }
    return tourConfig;
  });
  const demoTourSteps = [{
    step: 1,
    title: i18n.CREATE_RULE_TOUR_TITLE,
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, i18n.CREATE_RULE_TOUR_CONTENT)
  }];
  const finishTour = (0, _react.useCallback)(() => {
    setTourState({
      ...tourState,
      isTourActive: false
    });
  }, [tourState]);
  (0, _react.useEffect)(() => {
    storage.set(_constants.NEW_FEATURES_TOUR_STORAGE_KEYS.RULE_MANAGEMENT_PAGE, tourState);
  }, [tourState, storage]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, {
    content: demoTourSteps[0].content,
    isStepOpen: tourState.currentTourStep === 1 && tourState.isTourActive && !isGuidedOnboardingActive,
    minWidth: tourState.tourPopoverWidth,
    onFinish: finishTour,
    step: 1,
    stepsTotal: demoTourSteps.length,
    subtitle: tourState.tourSubtitle,
    title: demoTourSteps[0].title,
    anchorPosition: "rightUp"
  }, children);
};
exports.RulesPageTourComponent = RulesPageTourComponent;