"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddPrebuiltRulesHeaderButtons = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _user_info = require("../../../../../detections/components/user_info");
var _add_prebuilt_rules_table_context = require("./add_prebuilt_rules_table_context");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddPrebuiltRulesHeaderButtons = () => {
  var _selectedRules$length;
  const {
    state: {
      rules,
      selectedRules,
      loadingRules,
      isRefetching,
      isUpgradingSecurityPackages
    },
    actions: {
      installAllRules,
      installSelectedRules
    }
  } = (0, _add_prebuilt_rules_table_context.useAddPrebuiltRulesTableContext)();
  const [{
    loading: isUserDataLoading,
    canUserCRUD
  }] = (0, _user_info.useUserData)();
  const canUserEditRules = canUserCRUD && !isUserDataLoading;
  const isRulesAvailableForInstall = rules.length > 0;
  const numberOfSelectedRules = (_selectedRules$length = selectedRules.length) !== null && _selectedRules$length !== void 0 ? _selectedRules$length : 0;
  const shouldDisplayInstallSelectedRulesButton = numberOfSelectedRules > 0;
  const isRuleInstalling = loadingRules.length > 0;
  const isRequestInProgress = isRuleInstalling || isRefetching || isUpgradingSecurityPackages;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    wrap: true
  }, shouldDisplayInstallSelectedRulesButton ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: installSelectedRules,
    disabled: !canUserEditRules || isRequestInProgress,
    "data-test-subj": "installSelectedRulesButton"
  }, i18n.INSTALL_SELECTED_RULES(numberOfSelectedRules), isRuleInstalling ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s"
  }) : undefined)) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    iconType: "plusInCircle",
    "data-test-subj": "installAllRulesButton",
    onClick: installAllRules,
    disabled: !canUserEditRules || !isRulesAvailableForInstall || isRequestInProgress,
    "aria-label": i18n.INSTALL_ALL_ARIA_LABEL
  }, i18n.INSTALL_ALL, isRuleInstalling ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s"
  }) : undefined)));
};
exports.AddPrebuiltRulesHeaderButtons = AddPrebuiltRulesHeaderButtons;