"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SortingOptions = exports.PaginationOptions = void 0;
var z = _interopRequireWildcard(require("zod"));
var _detection_engine = require("../../../../common/api/detection_engine");
var _rule_management = require("../../../../common/api/detection_engine/rule_management");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PaginationOptions = exports.PaginationOptions = z.object({
  page: z.number().int().min(0),
  perPage: z.number().int().min(0),
  total: z.number().int().min(0)
});

// Rule snooze settings map keyed by rule SO's id (not ruleId) and valued by rule snooze settings

const SortingOptions = exports.SortingOptions = z.object({
  field: _rule_management.FindRulesSortField,
  order: _detection_engine.SortOrder
});