"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePerformInstallSpecificRules = exports.usePerformInstallAllRules = void 0;
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _use_perform_all_rules_install_mutation = require("../../api/hooks/prebuilt_rules/use_perform_all_rules_install_mutation");
var _use_perform_specific_rules_install_mutation = require("../../api/hooks/prebuilt_rules/use_perform_specific_rules_install_mutation");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usePerformInstallAllRules = () => {
  const {
    addError,
    addSuccess
  } = (0, _use_app_toasts.useAppToasts)();
  return (0, _use_perform_all_rules_install_mutation.usePerformAllRulesInstallMutation)({
    onError: err => {
      addError(err, {
        title: i18n.RULE_INSTALLATION_FAILED
      });
    },
    onSuccess: result => {
      addSuccess(getSuccessToastMessage(result));
    }
  });
};
exports.usePerformInstallAllRules = usePerformInstallAllRules;
const usePerformInstallSpecificRules = () => {
  const {
    addError,
    addSuccess
  } = (0, _use_app_toasts.useAppToasts)();
  return (0, _use_perform_specific_rules_install_mutation.usePerformSpecificRulesInstallMutation)({
    onError: err => {
      addError(err, {
        title: i18n.RULE_INSTALLATION_FAILED
      });
    },
    onSuccess: result => {
      addSuccess(getSuccessToastMessage(result));
    }
  });
};
exports.usePerformInstallSpecificRules = usePerformInstallSpecificRules;
const getSuccessToastMessage = result => {
  const toastMessages = [];
  const {
    summary: {
      succeeded,
      skipped,
      failed
    }
  } = result;
  if (succeeded > 0) {
    toastMessages.push(i18n.INSTALL_RULE_SUCCESS(succeeded));
  }
  if (skipped > 0) {
    toastMessages.push(i18n.INSTALL_RULE_SKIPPED(skipped));
  }
  if (failed > 0) {
    toastMessages.push(i18n.INSTALL_RULE_FAILED(failed));
  }
  return toastMessages.join(' ');
};