"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildCoverageOverviewDashboardModel = buildCoverageOverviewDashboardModel;
var _detection_engine = require("../../../../../common/api/detection_engine");
var _build_coverage_overview_mitre_graph = require("./build_coverage_overview_mitre_graph");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const lazyMitreConfiguration = () => {
  /**
   * The specially formatted comment in the `import` expression causes the corresponding webpack chunk to be named. This aids us in debugging chunk size issues.
   * See https://webpack.js.org/api/module-methods/#magic-comments
   */
  return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "lazy_mitre_configuration" */
  '../../../../detections/mitre/mitre_tactics_techniques')));
};
async function buildCoverageOverviewDashboardModel(apiResponse) {
  const mitreConfig = await lazyMitreConfiguration();
  const {
    tactics,
    techniques,
    subtechniques
  } = mitreConfig;
  const mitreTactics = (0, _build_coverage_overview_mitre_graph.buildCoverageOverviewMitreGraph)(tactics, techniques, subtechniques);
  for (const tactic of mitreTactics) {
    for (const ruleId of (_apiResponse$coverage = apiResponse.coverage[tactic.id]) !== null && _apiResponse$coverage !== void 0 ? _apiResponse$coverage : []) {
      var _apiResponse$coverage;
      addRule(tactic, ruleId, apiResponse.rules_data[ruleId]);
    }
    for (const technique of tactic.techniques) {
      for (const ruleId of (_apiResponse$coverage2 = apiResponse.coverage[technique.id]) !== null && _apiResponse$coverage2 !== void 0 ? _apiResponse$coverage2 : []) {
        var _apiResponse$coverage2, _apiResponse$coverage3;
        if ((_apiResponse$coverage3 = apiResponse.coverage[tactic.id]) !== null && _apiResponse$coverage3 !== void 0 && _apiResponse$coverage3.includes(ruleId)) {
          addRule(technique, ruleId, apiResponse.rules_data[ruleId]);
        }
      }
      for (const subtechnique of technique.subtechniques) {
        for (const ruleId of (_apiResponse$coverage4 = apiResponse.coverage[subtechnique.id]) !== null && _apiResponse$coverage4 !== void 0 ? _apiResponse$coverage4 : []) {
          var _apiResponse$coverage4, _apiResponse$coverage5;
          if ((_apiResponse$coverage5 = apiResponse.coverage[tactic.id]) !== null && _apiResponse$coverage5 !== void 0 && _apiResponse$coverage5.includes(ruleId)) {
            addRule(subtechnique, ruleId, apiResponse.rules_data[ruleId]);
          }
        }
      }
    }
  }
  return {
    mitreTactics,
    unmappedRules: buildUnmappedRules(apiResponse),
    metrics: calcMetrics(apiResponse.rules_data)
  };
}
function calcMetrics(rulesData) {
  const ruleIds = Object.keys(rulesData);
  const metrics = {
    totalRulesCount: ruleIds.length,
    totalEnabledRulesCount: 0
  };
  for (const ruleId of Object.keys(rulesData)) {
    if (rulesData[ruleId].activity === _detection_engine.CoverageOverviewRuleActivity.Enabled) {
      metrics.totalEnabledRulesCount++;
    }
  }
  return metrics;
}
function buildUnmappedRules(apiResponse) {
  const unmappedRules = {
    enabledRules: [],
    disabledRules: [],
    availableRules: []
  };
  for (const ruleId of apiResponse.unmapped_rule_ids) {
    addRule(unmappedRules, ruleId, apiResponse.rules_data[ruleId]);
  }
  return unmappedRules;
}
function addRule(container, ruleId, ruleData) {
  if (!ruleData) {
    return;
  }
  if (ruleData.activity === _detection_engine.CoverageOverviewRuleActivity.Enabled) {
    container.enabledRules.push({
      id: ruleId,
      name: ruleData.name
    });
  } else if (ruleData.activity === _detection_engine.CoverageOverviewRuleActivity.Disabled) {
    container.disabledRules.push({
      id: ruleId,
      name: ruleData.name
    });
  }

  // When we add support for available (not installed) rules to this feature, add the following here:
  // else if (ruleData.activity === CoverageOverviewRuleActivity.Available) {
  //   container.availableRules.push({
  //     id: ruleId,
  //     name: ruleData.name,
  //   });
  // }
}