"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PerFieldRuleDiffTab = void 0;
var _react = _interopRequireWildcard(require("react"));
var _get_formatted_field_diff = require("./per_field_diff/get_formatted_field_diff");
var _constants = require("./constants");
var _diff_components = require("./diff_components");
var _helpers = require("./helpers");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PerFieldRuleDiffTab = ({
  ruleDiff
}) => {
  const fieldsToRender = (0, _react.useMemo)(() => {
    const fields = [];
    for (const field of Object.keys(ruleDiff.fields)) {
      const typedField = field;
      const formattedDiffs = (0, _get_formatted_field_diff.getFormattedFieldDiffGroups)(typedField, ruleDiff.fields);
      fields.push({
        formattedDiffs,
        fieldsGroupName: typedField
      });
    }
    const sortedFields = fields.sort((a, b) => _constants.UPGRADE_FIELD_ORDER.indexOf(a.fieldsGroupName) - _constants.UPGRADE_FIELD_ORDER.indexOf(b.fieldsGroupName));
    return sortedFields;
  }, [ruleDiff.fields]);
  const {
    aboutFields,
    definitionFields,
    scheduleFields,
    setupFields
  } = (0, _react.useMemo)(() => (0, _helpers.getSectionedFieldDiffs)(fieldsToRender), [fieldsToRender]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_diff_components.RuleDiffHeaderBar, null), aboutFields.length !== 0 && /*#__PURE__*/_react.default.createElement(_diff_components.RuleDiffSection, {
    title: i18n.ABOUT_SECTION_LABEL,
    fieldGroups: aboutFields,
    dataTestSubj: "perFieldDiffAboutSection"
  }), definitionFields.length !== 0 && /*#__PURE__*/_react.default.createElement(_diff_components.RuleDiffSection, {
    title: i18n.DEFINITION_SECTION_LABEL,
    fieldGroups: definitionFields,
    dataTestSubj: "perFieldDiffDefinitionSection"
  }), scheduleFields.length !== 0 && /*#__PURE__*/_react.default.createElement(_diff_components.RuleDiffSection, {
    title: i18n.SCHEDULE_SECTION_LABEL,
    fieldGroups: scheduleFields,
    dataTestSubj: "perFieldDiffScheduleSection"
  }), setupFields.length !== 0 && /*#__PURE__*/_react.default.createElement(_diff_components.RuleDiffSection, {
    title: i18n.SETUP_GUIDE_SECTION_LABEL,
    fieldGroups: setupFields,
    dataTestSubj: "perFieldDiffSetupSection"
  }));
};
exports.PerFieldRuleDiffTab = PerFieldRuleDiffTab;