"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleDiffPanelWrapper = void 0;
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _css = require("@emotion/css");
var _react = _interopRequireDefault(require("react"));
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RuleDiffPanelWrapper = ({
  fieldName,
  children
}) => {
  var _fieldToDisplayNameMa;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    "data-test-subj": "ruleUpgradePerFieldDiffWrapper",
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    initialIsOpen: true,
    css: (0, _css.css)`
          .euiAccordion__triggerWrapper {
            background: ${euiTheme.colors.lightestShade};
            padding: ${euiTheme.size.m};
          }
        `,
    id: fieldName,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      "data-test-subj": "ruleUpgradePerFieldDiffLabel",
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h5", null, (_fieldToDisplayNameMa = _translations.fieldToDisplayNameMap[fieldName]) !== null && _fieldToDisplayNameMa !== void 0 ? _fieldToDisplayNameMa : (0, _lodash.startCase)((0, _lodash.camelCase)(fieldName))))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    "data-test-subj": "ruleUpgradePerFieldDiffContent",
    color: "transparent"
  }, children)));
};
exports.RuleDiffPanelWrapper = RuleDiffPanelWrapper;