"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInvalidateFetchPrebuiltRulesStatusQuery = exports.useFetchPrebuiltRulesStatusQuery = exports.PREBUILT_RULES_STATUS_QUERY_KEY = void 0;
var _react = require("react");
var _reactQuery = require("@tanstack/react-query");
var _api = require("../../api");
var _constants = require("../constants");
var _prebuilt_rules = require("../../../../../../common/api/detection_engine/prebuilt_rules");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PREBUILT_RULES_STATUS_QUERY_KEY = exports.PREBUILT_RULES_STATUS_QUERY_KEY = ['GET', _prebuilt_rules.GET_PREBUILT_RULES_STATUS_URL];
const useFetchPrebuiltRulesStatusQuery = options => {
  return (0, _reactQuery.useQuery)(PREBUILT_RULES_STATUS_QUERY_KEY, async ({
    signal
  }) => {
    const response = await (0, _api.getPrebuiltRulesStatus)({
      signal
    });
    return response.stats;
  }, {
    ..._constants.DEFAULT_QUERY_OPTIONS,
    ...options
  });
};

/**
 * We should use this hook to invalidate the prepackaged rules cache. For
 * example, rule mutations that affect rule set size, like creation, deletion,
 * or installing and updating (which affect the stats) should lead to cache invalidation.
 *
 * @returns A rules cache invalidation callback
 */
exports.useFetchPrebuiltRulesStatusQuery = useFetchPrebuiltRulesStatusQuery;
const useInvalidateFetchPrebuiltRulesStatusQuery = () => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  return (0, _react.useCallback)(() => {
    queryClient.invalidateQueries(PREBUILT_RULES_STATUS_QUERY_KEY, {
      refetchType: 'active'
    });
  }, [queryClient]);
};
exports.useInvalidateFetchPrebuiltRulesStatusQuery = useInvalidateFetchPrebuiltRulesStatusQuery;