"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EDIT_RULE_EXCEPTION_SUCCESS_TITLE = exports.EDIT_RULE_EXCEPTION_SUCCESS_TEXT = exports.EDIT_RULE_EXCEPTION_ERROR_TITLE = exports.EDIT_EXCEPTION_TITLE = exports.EDIT_ENDPOINT_EXCEPTION_TITLE = exports.COMMENTS_SECTION_TITLE = exports.CANCEL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CANCEL = exports.CANCEL = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.editException.cancel', {
  defaultMessage: 'Cancel'
});
const EDIT_EXCEPTION_TITLE = exports.EDIT_EXCEPTION_TITLE = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.editException.editExceptionTitle', {
  defaultMessage: 'Edit rule exception'
});
const EDIT_ENDPOINT_EXCEPTION_TITLE = exports.EDIT_ENDPOINT_EXCEPTION_TITLE = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.editException.editEndpointExceptionTitle', {
  defaultMessage: 'Edit endpoint exception'
});
const EDIT_RULE_EXCEPTION_SUCCESS_TITLE = exports.EDIT_RULE_EXCEPTION_SUCCESS_TITLE = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.editException.editRuleExceptionToastSuccessTitle', {
  defaultMessage: 'Rule exception updated'
});
const EDIT_RULE_EXCEPTION_SUCCESS_TEXT = (exceptionItemName, numItems) => _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.editException.editRuleExceptionToastSuccessText', {
  values: {
    exceptionItemName,
    numItems
  },
  defaultMessage: '{numItems, plural, =1 {Exception} other {Exceptions}} - {exceptionItemName} - {numItems, plural, =1 {has} other {have}} been updated.'
});
exports.EDIT_RULE_EXCEPTION_SUCCESS_TEXT = EDIT_RULE_EXCEPTION_SUCCESS_TEXT;
const EDIT_RULE_EXCEPTION_ERROR_TITLE = exports.EDIT_RULE_EXCEPTION_ERROR_TITLE = _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.editException.editRuleExceptionToastErrorTitle', {
  defaultMessage: 'Error updating exception'
});
const COMMENTS_SECTION_TITLE = comments => _i18n.i18n.translate('xpack.securitySolution.ruleExceptions.editExceptionFlyout.commentsTitle', {
  values: {
    comments
  },
  defaultMessage: 'Add comments ({comments})'
});
exports.COMMENTS_SECTION_TITLE = COMMENTS_SECTION_TITLE;