"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRuleDetailsTabs = exports.RuleDetailTabs = exports.RULE_DETAILS_TAB_NAME = void 0;
var _react = require("react");
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var _fp = require("lodash/fp");
var _use_endpoint_exceptions_capability = require("../../../../exceptions/hooks/use_endpoint_exceptions_capability");
var detectionI18n = _interopRequireWildcard(require("../../../../detections/pages/detection_engine/translations"));
var i18n = _interopRequireWildcard(require("./translations"));
var _rule_monitoring = require("../../../rule_monitoring");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let RuleDetailTabs = exports.RuleDetailTabs = /*#__PURE__*/function (RuleDetailTabs) {
  RuleDetailTabs["alerts"] = "alerts";
  RuleDetailTabs["exceptions"] = "rule_exceptions";
  RuleDetailTabs["endpointExceptions"] = "endpoint_exceptions";
  RuleDetailTabs["executionResults"] = "execution_results";
  RuleDetailTabs["executionEvents"] = "execution_events";
  return RuleDetailTabs;
}({});
const RULE_DETAILS_TAB_NAME = exports.RULE_DETAILS_TAB_NAME = {
  [RuleDetailTabs.alerts]: detectionI18n.ALERT,
  [RuleDetailTabs.exceptions]: i18n.EXCEPTIONS_TAB,
  [RuleDetailTabs.endpointExceptions]: i18n.ENDPOINT_EXCEPTIONS_TAB,
  [RuleDetailTabs.executionResults]: i18n.EXECUTION_RESULTS_TAB,
  [RuleDetailTabs.executionEvents]: i18n.EXECUTION_EVENTS_TAB
};
const useRuleDetailsTabs = ({
  rule,
  ruleId,
  isExistingRule,
  hasIndexRead
}) => {
  const ruleDetailTabs = (0, _react.useMemo)(() => ({
    [RuleDetailTabs.alerts]: {
      id: RuleDetailTabs.alerts,
      name: RULE_DETAILS_TAB_NAME[RuleDetailTabs.alerts],
      disabled: false,
      href: `/rules/id/${ruleId}/${RuleDetailTabs.alerts}`
    },
    [RuleDetailTabs.exceptions]: {
      id: RuleDetailTabs.exceptions,
      name: RULE_DETAILS_TAB_NAME[RuleDetailTabs.exceptions],
      disabled: rule == null,
      href: `/rules/id/${ruleId}/${RuleDetailTabs.exceptions}`
    },
    [RuleDetailTabs.endpointExceptions]: {
      id: RuleDetailTabs.endpointExceptions,
      name: RULE_DETAILS_TAB_NAME[RuleDetailTabs.endpointExceptions],
      disabled: rule == null,
      href: `/rules/id/${ruleId}/${RuleDetailTabs.endpointExceptions}`
    },
    [RuleDetailTabs.executionResults]: {
      id: RuleDetailTabs.executionResults,
      name: RULE_DETAILS_TAB_NAME[RuleDetailTabs.executionResults],
      disabled: !isExistingRule,
      href: `/rules/id/${ruleId}/${RuleDetailTabs.executionResults}`
    },
    [RuleDetailTabs.executionEvents]: {
      id: RuleDetailTabs.executionEvents,
      name: RULE_DETAILS_TAB_NAME[RuleDetailTabs.executionEvents],
      disabled: !isExistingRule,
      href: `/rules/id/${ruleId}/${RuleDetailTabs.executionEvents}`
    }
  }), [isExistingRule, rule, ruleId]);
  const [pageTabs, setTabs] = (0, _react.useState)(ruleDetailTabs);
  const ruleExecutionSettings = (0, _rule_monitoring.useRuleExecutionSettings)();
  const canReadEndpointExceptions = (0, _use_endpoint_exceptions_capability.useEndpointExceptionsCapability)('showEndpointExceptions');
  (0, _react.useEffect)(() => {
    const hiddenTabs = [];
    if (!hasIndexRead) {
      hiddenTabs.push(RuleDetailTabs.alerts);
    }
    if (!ruleExecutionSettings.extendedLogging.isEnabled) {
      hiddenTabs.push(RuleDetailTabs.executionEvents);
    }
    if (!canReadEndpointExceptions) {
      hiddenTabs.push(RuleDetailTabs.endpointExceptions);
    }
    if (rule != null) {
      var _rule$exceptions_list;
      const hasEndpointList = ((_rule$exceptions_list = rule.exceptions_list) !== null && _rule$exceptions_list !== void 0 ? _rule$exceptions_list : []).some(list => list.type === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT);
      if (!hasEndpointList) {
        hiddenTabs.push(RuleDetailTabs.endpointExceptions);
      }
    }
    const tabs = (0, _fp.omit)(hiddenTabs, ruleDetailTabs);
    setTabs(tabs);
  }, [canReadEndpointExceptions, hasIndexRead, rule, ruleDetailTabs, ruleExecutionSettings]);
  return pageTabs;
};
exports.useRuleDetailsTabs = useRuleDetailsTabs;