"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSavedQueryCheckboxLabelWithoutName = exports.getSavedQueryCheckboxLabel = exports.getEnableThresholdSuppressionLabel = exports.THRESHOLD_SUPPRESSION_PER_RULE_EXECUTION_WARNING = exports.THREAT_MATCH_REQUIRED = exports.THREAT_MATCH_INDEX_HELPER_TEXT = exports.THREAT_MATCH_EMPTIES = exports.SOURCE = exports.SAVED_QUERY_FORM_ROW_LABEL = exports.RULE_PREVIEW_TITLE = exports.RESET_DEFAULT_INDEX = exports.QUERY_BAR_LABEL = exports.INVALID_CUSTOM_QUERY = exports.INDEX_HELPER_TEXT = exports.IMPORT_TIMELINE_QUERY = exports.GROUP_BY_TECH_PREVIEW_LABEL_APPEND = exports.GROUP_BY_LABEL = exports.GROUP_BY_GA_LABEL_APPEND = exports.ESQL_QUERY_REQUIRED = exports.ESQL_QUERY = exports.EQL_SEQUENCE_SUPPRESSION_GROUPBY_VALIDATION_TEXT = exports.EQL_SEQUENCE_SUPPRESSION_DISABLE_TOOLTIP = exports.EQL_QUERY_REQUIRED = exports.EQL_QUERY_BAR_LABEL = exports.DATA_SOURCE_GUIDE_TITLE = exports.DATA_SOURCE_GUIDE_SUB_TITLE = exports.DATA_SOURCE_GUIDE_CONTENT = exports.CUSTOM_QUERY_REQUIRED = exports.ALERT_SUPPRESSION_PER_TIME_PERIOD = exports.ALERT_SUPPRESSION_PER_RULE_EXECUTION = exports.ALERT_SUPPRESSION_MISSING_FIELDS_SUPPRESS_OPTION = exports.ALERT_SUPPRESSION_MISSING_FIELDS_FORM_ROW_LABEL = exports.ALERT_SUPPRESSION_MISSING_FIELDS_DO_NOT_SUPPRESS_OPTION = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CUSTOM_QUERY_REQUIRED = exports.CUSTOM_QUERY_REQUIRED = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.customQueryFieldRequiredError', {
  defaultMessage: 'A custom query is required.'
});
const EQL_QUERY_REQUIRED = exports.EQL_QUERY_REQUIRED = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.eqlQueryFieldRequiredError', {
  defaultMessage: 'An EQL query is required.'
});
const ESQL_QUERY_REQUIRED = exports.ESQL_QUERY_REQUIRED = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.esqlQueryFieldRequiredError', {
  defaultMessage: 'An ES|QL query is required.'
});
const INVALID_CUSTOM_QUERY = exports.INVALID_CUSTOM_QUERY = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.customQueryFieldInvalidError', {
  defaultMessage: 'The KQL is invalid'
});
const INDEX_HELPER_TEXT = exports.INDEX_HELPER_TEXT = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.indicesHelperDescription', {
  defaultMessage: 'Enter the pattern of Elasticsearch indices where you would like this rule to run. By default, these will include index patterns defined in Security Solution advanced settings.'
});
const RESET_DEFAULT_INDEX = exports.RESET_DEFAULT_INDEX = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.resetDefaultIndicesButton', {
  defaultMessage: 'Reset to default index patterns'
});
const IMPORT_TIMELINE_QUERY = exports.IMPORT_TIMELINE_QUERY = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.importTimelineQueryButton', {
  defaultMessage: 'Import query from saved timeline'
});
const QUERY_BAR_LABEL = exports.QUERY_BAR_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.fieldQuerBarLabel', {
  defaultMessage: 'Custom query'
});
const EQL_QUERY_BAR_LABEL = exports.EQL_QUERY_BAR_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.EqlQueryBarLabel', {
  defaultMessage: 'EQL query'
});
const SAVED_QUERY_FORM_ROW_LABEL = exports.SAVED_QUERY_FORM_ROW_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.SavedQueryFormRowLabel', {
  defaultMessage: 'Saved query'
});
const getSavedQueryCheckboxLabel = savedQueryName => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.fieldShouldLoadQueryDynamicallyLabel', {
  defaultMessage: 'Load saved query "{savedQueryName}" dynamically on each rule execution',
  values: {
    savedQueryName
  }
});
exports.getSavedQueryCheckboxLabel = getSavedQueryCheckboxLabel;
const getSavedQueryCheckboxLabelWithoutName = () => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.fieldShouldLoadQueryDynamicallyLabelWithoutName', {
  defaultMessage: 'Load saved query dynamically on each rule execution'
});
exports.getSavedQueryCheckboxLabelWithoutName = getSavedQueryCheckboxLabelWithoutName;
const THREAT_MATCH_INDEX_HELPER_TEXT = exports.THREAT_MATCH_INDEX_HELPER_TEXT = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.threatMatchingIcesHelperDescription', {
  defaultMessage: 'Select threat indices'
});
const THREAT_MATCH_REQUIRED = exports.THREAT_MATCH_REQUIRED = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.customThreatQueryFieldRequiredError', {
  defaultMessage: 'At least one indicator match is required.'
});
const THREAT_MATCH_EMPTIES = exports.THREAT_MATCH_EMPTIES = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.customThreatQueryFieldRequiredEmptyError', {
  defaultMessage: 'All matches require both a field and threat index field.'
});
const SOURCE = exports.SOURCE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.source', {
  defaultMessage: 'Source'
});
const DATA_SOURCE_GUIDE_SUB_TITLE = exports.DATA_SOURCE_GUIDE_SUB_TITLE = _i18n.i18n.translate('xpack.securitySolution.detections.dataSource.popover.title', {
  defaultMessage: 'Select a data source'
});
const DATA_SOURCE_GUIDE_TITLE = exports.DATA_SOURCE_GUIDE_TITLE = _i18n.i18n.translate('xpack.securitySolution.detections.dataSource.popover.subTitle', {
  defaultMessage: 'Data sources'
});
const DATA_SOURCE_GUIDE_CONTENT = exports.DATA_SOURCE_GUIDE_CONTENT = _i18n.i18n.translate('xpack.securitySolution.detections.dataSource.popover.content', {
  defaultMessage: 'Rules can now query index patterns or data views.'
});
const RULE_PREVIEW_TITLE = exports.RULE_PREVIEW_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.rulePreviewTitle', {
  defaultMessage: 'Rule Preview'
});
const ALERT_SUPPRESSION_MISSING_FIELDS_FORM_ROW_LABEL = exports.ALERT_SUPPRESSION_MISSING_FIELDS_FORM_ROW_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.alertSuppressionMissingFieldsLabel', {
  defaultMessage: 'If a suppression field is missing'
});
const ALERT_SUPPRESSION_MISSING_FIELDS_SUPPRESS_OPTION = exports.ALERT_SUPPRESSION_MISSING_FIELDS_SUPPRESS_OPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.alertSuppressionMissingFieldsSuppressLabel', {
  defaultMessage: 'Suppress and group alerts for events with missing fields'
});
const ALERT_SUPPRESSION_MISSING_FIELDS_DO_NOT_SUPPRESS_OPTION = exports.ALERT_SUPPRESSION_MISSING_FIELDS_DO_NOT_SUPPRESS_OPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.alertSuppressionMissingFieldsDoNotSuppressLabel', {
  defaultMessage: 'Do not suppress alerts for events with missing fields'
});
const ESQL_QUERY = exports.ESQL_QUERY = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.esqlQueryLabel', {
  defaultMessage: 'ES|QL query'
});
const ALERT_SUPPRESSION_PER_RULE_EXECUTION = exports.ALERT_SUPPRESSION_PER_RULE_EXECUTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.alertSuppressionOptions.perRuleExecutionLabel', {
  defaultMessage: 'Per rule execution'
});
const ALERT_SUPPRESSION_PER_TIME_PERIOD = exports.ALERT_SUPPRESSION_PER_TIME_PERIOD = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.alertSuppressionOptions.perTimePeriodLabel', {
  defaultMessage: 'Per time period'
});
const THRESHOLD_SUPPRESSION_PER_RULE_EXECUTION_WARNING = exports.THRESHOLD_SUPPRESSION_PER_RULE_EXECUTION_WARNING = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.Su.perRuleExecutionWarning', {
  defaultMessage: 'Per rule execution option is not available for Threshold rule type'
});
const getEnableThresholdSuppressionLabel = fields => fields !== null && fields !== void 0 && fields.length ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.detectionEngine.createRule.stepDefineRule.enableThresholdSuppressionForFieldsLabel",
  defaultMessage: "Suppress alerts by selected fields: {fieldsString} (Technical Preview)",
  values: {
    fieldsString: /*#__PURE__*/_react.default.createElement("strong", null, fields.join(', '))
  }
}) : _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.enableThresholdSuppressionLabel', {
  defaultMessage: 'Suppress alerts (Technical Preview)'
});
exports.getEnableThresholdSuppressionLabel = getEnableThresholdSuppressionLabel;
const EQL_SEQUENCE_SUPPRESSION_DISABLE_TOOLTIP = exports.EQL_SEQUENCE_SUPPRESSION_DISABLE_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.eqlSequenceSuppressionDisableText', {
  defaultMessage: 'Suppression is not supported for EQL sequence queries.'
});
const EQL_SEQUENCE_SUPPRESSION_GROUPBY_VALIDATION_TEXT = exports.EQL_SEQUENCE_SUPPRESSION_GROUPBY_VALIDATION_TEXT = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.eqlSequenceSuppressionValidationText', {
  defaultMessage: '{EQL_SEQUENCE_SUPPRESSION_DISABLE_TOOLTIP} Change the EQL query to a non-sequence query, or remove the suppression fields.',
  values: {
    EQL_SEQUENCE_SUPPRESSION_DISABLE_TOOLTIP
  }
});
const GROUP_BY_TECH_PREVIEW_LABEL_APPEND = exports.GROUP_BY_TECH_PREVIEW_LABEL_APPEND = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.groupByFieldsTechPreviewLabelAppend', {
  defaultMessage: 'Optional (Technical Preview)'
});
const GROUP_BY_GA_LABEL_APPEND = exports.GROUP_BY_GA_LABEL_APPEND = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.groupByFieldsGALabelAppend', {
  defaultMessage: 'Optional'
});
const GROUP_BY_LABEL = exports.GROUP_BY_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.groupByFieldsLabel', {
  defaultMessage: 'Suppress alerts by'
});