"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePreviewRoute = void 0;
var _react = require("react");
var _use_preview_rule = require("./use_preview_rule");
var _helpers = require("../../pages/rule_creation/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usePreviewRoute = ({
  defineRuleData,
  aboutRuleData,
  scheduleRuleData,
  exceptionsList,
  timeframeOptions
}) => {
  var _response$logs, _response$previewId;
  const [isRequestTriggered, setIsRequestTriggered] = (0, _react.useState)(false);
  const {
    isLoading,
    response,
    rule,
    setRule
  } = (0, _use_preview_rule.usePreviewRule)({
    timeframeOptions
  });
  const [logs, setLogs] = (0, _react.useState)((_response$logs = response.logs) !== null && _response$logs !== void 0 ? _response$logs : []);
  const [isAborted, setIsAborted] = (0, _react.useState)(!!response.isAborted);
  const [hasNoiseWarning, setHasNoiseWarning] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    var _response$logs2;
    setLogs((_response$logs2 = response.logs) !== null && _response$logs2 !== void 0 ? _response$logs2 : []);
    setIsAborted(!!response.isAborted);
  }, [response]);
  const addNoiseWarning = (0, _react.useCallback)(() => {
    setHasNoiseWarning(true);
  }, [setHasNoiseWarning]);
  const clearPreview = (0, _react.useCallback)(() => {
    setRule(null);
    setLogs([]);
    setIsAborted(false);
    setIsRequestTriggered(false);
    setHasNoiseWarning(false);
  }, [setRule]);
  (0, _react.useEffect)(() => {
    clearPreview();
  }, [clearPreview, defineRuleData, aboutRuleData, scheduleRuleData]);
  (0, _react.useEffect)(() => {
    if (!defineRuleData || !aboutRuleData || !scheduleRuleData) {
      return;
    }
    if (isRequestTriggered && rule === null) {
      setRule((0, _helpers.formatPreviewRule)({
        defineRuleData,
        aboutRuleData,
        scheduleRuleData,
        exceptionsList
      }));
    }
  }, [isRequestTriggered, rule, setRule, defineRuleData, aboutRuleData, scheduleRuleData, exceptionsList]);
  return {
    hasNoiseWarning,
    addNoiseWarning,
    createPreview: () => setIsRequestTriggered(true),
    clearPreview,
    isPreviewRequestInProgress: isLoading,
    previewId: (_response$previewId = response.previewId) !== null && _response$previewId !== void 0 ? _response$previewId : '',
    logs,
    isAborted
  };
};
exports.usePreviewRoute = usePreviewRoute;