"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultiSelectFieldsAutocomplete = exports.MultiSelectAutocompleteComponent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../shared_imports");
var _translations = require("./translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FIELD_COMBO_BOX_WIDTH = 410;
const fieldDescribedByIds = 'detectionEngineMultiSelectAutocompleteField';
const MultiSelectAutocompleteComponent = ({
  browserFields,
  disabledText,
  isDisabled,
  field,
  fullWidth = false,
  dataTestSubj
}) => {
  const fieldEuiFieldProps = (0, _react.useMemo)(() => ({
    fullWidth: true,
    noSuggestions: false,
    options: browserFields.map(browserField => ({
      label: browserField.name
    })),
    placeholder: _translations.FIELD_PLACEHOLDER,
    onCreateOption: undefined,
    ...(fullWidth ? {} : {
      style: {
        width: `${FIELD_COMBO_BOX_WIDTH}px`
      }
    }),
    isDisabled
  }), [browserFields, isDisabled, fullWidth]);
  const fieldComponent = /*#__PURE__*/_react.default.createElement(_shared_imports.Field, {
    field: field,
    idAria: fieldDescribedByIds,
    euiFieldProps: fieldEuiFieldProps,
    "data-test-subj": dataTestSubj
  });
  return isDisabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "right",
    content: disabledText
  }, fieldComponent) : fieldComponent;
};
exports.MultiSelectAutocompleteComponent = MultiSelectAutocompleteComponent;
const MultiSelectFieldsAutocomplete = exports.MultiSelectFieldsAutocomplete = /*#__PURE__*/_react.default.memo(MultiSelectAutocompleteComponent);