"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.esqlValidationErrorMessage = exports.ESQL_VALIDATION_UNKNOWN_ERROR = exports.ESQL_VALIDATION_MISSING_ID_IN_QUERY_ERROR = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ESQL_VALIDATION_UNKNOWN_ERROR = exports.ESQL_VALIDATION_UNKNOWN_ERROR = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.esqlValidation.unknownError', {
  defaultMessage: 'Unknown error while validating ES|QL'
});
const esqlValidationErrorMessage = message => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.esqlValidation.errorMessage', {
  values: {
    message
  },
  defaultMessage: 'Error validating ES|QL: "{message}"'
});
exports.esqlValidationErrorMessage = esqlValidationErrorMessage;
const ESQL_VALIDATION_MISSING_ID_IN_QUERY_ERROR = exports.ESQL_VALIDATION_MISSING_ID_IN_QUERY_ERROR = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.esqlValidation.missingIdInQueryError', {
  defaultMessage: `Queries that don’t use the STATS...BY function (non-aggregating queries) must include the "metadata _id, _version, _index" operator after the source command. For example: FROM logs* metadata _id, _version, _index.  In addition, the metadata properties (_id, _version, and _index)  must be returned in the query response.`
});