"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.userName = exports.sourceIP = exports.sourceAddress = exports.ruleName = exports.hostName = exports.destinationAddress = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ruleName = exports.ruleName = _i18n.i18n.translate('xpack.securitySolution.selector.groups.ruleName.label', {
  defaultMessage: 'Rule name'
});
const userName = exports.userName = _i18n.i18n.translate('xpack.securitySolution.selector.grouping.userName.label', {
  defaultMessage: 'User name'
});
const hostName = exports.hostName = _i18n.i18n.translate('xpack.securitySolution.selector.grouping.hostName.label', {
  defaultMessage: 'Host name'
});
const sourceIP = exports.sourceIP = _i18n.i18n.translate('xpack.securitySolution.selector.grouping.sourceIP.label', {
  defaultMessage: 'Source IP'
});
const sourceAddress = exports.sourceAddress = _i18n.i18n.translate('xpack.securitySolution.selector.groups.sourceAddress.label', {
  defaultMessage: 'Source address'
});
const destinationAddress = exports.destinationAddress = _i18n.i18n.translate('xpack.securitySolution.selector.groups.destinationAddress.label', {
  defaultMessage: 'Destination address'
});