"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTimelineClick = void 0;
var _react = require("react");
var _helpers = require("../../../timelines/components/open_timeline/helpers");
var _use_experimental_features = require("../../hooks/use_experimental_features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useTimelineClick = () => {
  const queryTimelineById = (0, _helpers.useQueryTimelineById)();
  const unifiedComponentsInTimelineEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('unifiedComponentsInTimelineEnabled');
  const handleTimelineClick = (0, _react.useCallback)((timelineId, onError, graphEventId) => {
    queryTimelineById({
      graphEventId,
      timelineId,
      onError,
      unifiedComponentsInTimelineEnabled
    });
  }, [queryTimelineById, unifiedComponentsInTimelineEnabled]);
  return handleTimelineClick;
};
exports.useTimelineClick = useTimelineClick;