"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dataTableLocalStorageMiddleware = void 0;
var _fp = require("lodash/fp");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _actions = require("../../../timelines/store/actions");
var _local_storage = require("../../../timelines/containers/local_storage");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  applyDeltaToColumnWidth,
  changeViewMode,
  removeColumn,
  toggleDetailPanel,
  updateColumnOrder,
  updateColumns,
  updateColumnWidth,
  updateIsLoading,
  updateItemsPerPage,
  updateShowBuildingBlockAlertsFilter,
  updateSort,
  upsertColumn
} = _securitysolutionDataTable.dataTableActions;
const tableActionTypes = new Set([removeColumn.type, upsertColumn.type, applyDeltaToColumnWidth.type, updateColumns.type, updateColumnOrder.type, updateColumnWidth.type, updateItemsPerPage.type, updateSort.type, changeViewMode.type, updateShowBuildingBlockAlertsFilter.type, _actions.updateTotalCount.type, updateIsLoading.type, toggleDetailPanel.type]);
const dataTableLocalStorageMiddleware = storage => store => next => action => {
  // perform the action
  const ret = next(action);

  // persist the data table state when a table action has been performed
  if (tableActionTypes.has(action.type)) {
    const tableById = _securitysolutionDataTable.dataTableSelectors.tableByIdSelector(store.getState());
    const tableId = (0, _fp.get)('payload.id', action);
    if (tableById && tableById[tableId] && storage) {
      (0, _local_storage.addTableInStorage)(storage, tableId, tableById[tableId]);
    }
  }
  return ret;
};
exports.dataTableLocalStorageMiddleware = dataTableLocalStorageMiddleware;