"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TelemetryService = void 0;
var _rxjs = require("rxjs");
var _telemetry_events = require("./events/telemetry_events");
var _telemetry_client = require("./telemetry_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Service that interacts with the Core's analytics module
 * to trigger custom event for Security Solution plugin features
 */
class TelemetryService {
  constructor(analytics = null) {
    this.analytics = analytics;
  }
  setup({
    analytics
  }, context) {
    this.analytics = analytics;
    if (context) {
      const context$ = (0, _rxjs.of)(context);
      analytics.registerContextProvider({
        name: 'detection_response',
        // RxJS Observable that emits every time the context changes.
        context$,
        // Similar to the `reportEvent` API, schema defining the structure of the expected output of the context$ observable.
        schema: {
          prebuiltRulesPackageVersion: {
            type: 'keyword',
            _meta: {
              description: 'The version of prebuilt rules',
              optional: true
            }
          }
        }
      });
    }
    _telemetry_events.telemetryEvents.forEach(eventConfig => analytics.registerEventType(eventConfig));
  }
  start() {
    if (!this.analytics) {
      throw new Error('The TelemetryService.setup() method has not been invoked, be sure to call it during the plugin setup.');
    }
    return new _telemetry_client.TelemetryClient(this.analytics);
  }
}
exports.TelemetryService = TelemetryService;