"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toggleRiskSummaryClickedEvent = exports.entityRiskFilteredEvent = exports.entityClickedEvent = exports.entityAlertsClickedEvent = exports.assetCriticalityFileSelectedEvent = exports.assetCriticalityCsvPreviewGeneratedEvent = exports.assetCriticalityCsvImportedEvent = exports.addRiskInputToTimelineClickedEvent = exports.RiskInputsExpandedFlyoutOpenedEvent = void 0;
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const entityClickedEvent = exports.entityClickedEvent = {
  eventType: _constants.TelemetryEventTypes.EntityDetailsClicked,
  schema: {
    entity: {
      type: 'keyword',
      _meta: {
        description: 'Entity name (host|user)',
        optional: false
      }
    }
  }
};
const entityAlertsClickedEvent = exports.entityAlertsClickedEvent = {
  eventType: _constants.TelemetryEventTypes.EntityAlertsClicked,
  schema: {
    entity: {
      type: 'keyword',
      _meta: {
        description: 'Entity name (host|user)',
        optional: false
      }
    }
  }
};
const entityRiskFilteredEvent = exports.entityRiskFilteredEvent = {
  eventType: _constants.TelemetryEventTypes.EntityRiskFiltered,
  schema: {
    entity: {
      type: 'keyword',
      _meta: {
        description: 'Entity name (host|user)',
        optional: false
      }
    },
    selectedSeverity: {
      type: 'keyword',
      _meta: {
        description: 'Selected severity (Unknown|Low|Moderate|High|Critical)',
        optional: false
      }
    }
  }
};
const toggleRiskSummaryClickedEvent = exports.toggleRiskSummaryClickedEvent = {
  eventType: _constants.TelemetryEventTypes.ToggleRiskSummaryClicked,
  schema: {
    entity: {
      type: 'keyword',
      _meta: {
        description: 'Entity name (host|user)',
        optional: false
      }
    },
    action: {
      type: 'keyword',
      _meta: {
        description: 'It defines if the section is opening or closing (show|hide)',
        optional: false
      }
    }
  }
};
const RiskInputsExpandedFlyoutOpenedEvent = exports.RiskInputsExpandedFlyoutOpenedEvent = {
  eventType: _constants.TelemetryEventTypes.RiskInputsExpandedFlyoutOpened,
  schema: {
    entity: {
      type: 'keyword',
      _meta: {
        description: 'Entity name (host|user)',
        optional: false
      }
    }
  }
};
const addRiskInputToTimelineClickedEvent = exports.addRiskInputToTimelineClickedEvent = {
  eventType: _constants.TelemetryEventTypes.AddRiskInputToTimelineClicked,
  schema: {
    quantity: {
      type: 'integer',
      _meta: {
        description: 'Quantity of alerts added to timeline',
        optional: false
      }
    }
  }
};
const assetCriticalityFileSelectedEvent = exports.assetCriticalityFileSelectedEvent = {
  eventType: _constants.TelemetryEventTypes.AssetCriticalityFileSelected,
  schema: {
    valid: {
      type: 'boolean',
      _meta: {
        description: 'If the file is valid',
        optional: false
      }
    },
    errorCode: {
      type: 'keyword',
      _meta: {
        description: 'Error code if the file is invalid',
        optional: true
      }
    },
    file: {
      properties: {
        size: {
          type: 'long',
          _meta: {
            description: 'File size in bytes',
            optional: false
          }
        }
      }
    }
  }
};
const assetCriticalityCsvPreviewGeneratedEvent = exports.assetCriticalityCsvPreviewGeneratedEvent = {
  eventType: _constants.TelemetryEventTypes.AssetCriticalityCsvPreviewGenerated,
  schema: {
    file: {
      properties: {
        size: {
          type: 'long',
          _meta: {
            description: 'File size in bytes',
            optional: false
          }
        }
      }
    },
    processing: {
      properties: {
        startTime: {
          type: 'date',
          _meta: {
            description: 'Processing start time',
            optional: false
          }
        },
        endTime: {
          type: 'date',
          _meta: {
            description: 'Processing end time',
            optional: false
          }
        },
        tookMs: {
          type: 'long',
          _meta: {
            description: 'Processing time in milliseconds',
            optional: false
          }
        }
      }
    },
    stats: {
      properties: {
        validLines: {
          type: 'long',
          _meta: {
            description: 'Number of valid lines',
            optional: false
          }
        },
        invalidLines: {
          type: 'long',
          _meta: {
            description: 'Number of invalid lines',
            optional: false
          }
        },
        totalLines: {
          type: 'long',
          _meta: {
            description: 'Total number of lines',
            optional: false
          }
        }
      }
    }
  }
};
const assetCriticalityCsvImportedEvent = exports.assetCriticalityCsvImportedEvent = {
  eventType: _constants.TelemetryEventTypes.AssetCriticalityCsvImported,
  schema: {
    file: {
      properties: {
        size: {
          type: 'long',
          _meta: {
            description: 'File size in bytes',
            optional: false
          }
        }
      }
    }
  }
};