"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.assistantSettingToggledEvent = exports.assistantQuickPrompt = exports.assistantMessageSentEvent = exports.assistantInvokedEvent = void 0;
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const assistantInvokedEvent = exports.assistantInvokedEvent = {
  eventType: _constants.TelemetryEventTypes.AssistantInvoked,
  schema: {
    conversationId: {
      type: 'keyword',
      _meta: {
        description: 'Active conversation ID',
        optional: false
      }
    },
    invokedBy: {
      type: 'keyword',
      _meta: {
        description: 'Invocation method',
        optional: false
      }
    }
  }
};
const assistantMessageSentEvent = exports.assistantMessageSentEvent = {
  eventType: _constants.TelemetryEventTypes.AssistantMessageSent,
  schema: {
    conversationId: {
      type: 'keyword',
      _meta: {
        description: 'Active conversation ID',
        optional: false
      }
    },
    role: {
      type: 'keyword',
      _meta: {
        description: 'Conversation role',
        optional: false
      }
    },
    isEnabledKnowledgeBase: {
      type: 'boolean',
      _meta: {
        description: 'Is knowledge base enabled',
        optional: false
      }
    },
    isEnabledRAGAlerts: {
      type: 'boolean',
      _meta: {
        description: 'Is RAG on Alerts enabled',
        optional: false
      }
    },
    actionTypeId: {
      type: 'keyword',
      _meta: {
        description: 'Kibana connector type',
        optional: false
      }
    },
    model: {
      type: 'keyword',
      _meta: {
        description: 'LLM model',
        optional: true
      }
    },
    provider: {
      type: 'keyword',
      _meta: {
        description: 'OpenAI provider',
        optional: true
      }
    }
  }
};
const assistantQuickPrompt = exports.assistantQuickPrompt = {
  eventType: _constants.TelemetryEventTypes.AssistantQuickPrompt,
  schema: {
    conversationId: {
      type: 'keyword',
      _meta: {
        description: 'Active conversation ID',
        optional: false
      }
    },
    promptTitle: {
      type: 'keyword',
      _meta: {
        description: 'Title of the quick prompt',
        optional: false
      }
    }
  }
};
const assistantSettingToggledEvent = exports.assistantSettingToggledEvent = {
  eventType: _constants.TelemetryEventTypes.AssistantSettingToggled,
  schema: {
    isEnabledKnowledgeBase: {
      type: 'boolean',
      _meta: {
        description: 'Is knowledge base enabled',
        optional: true
      }
    },
    isEnabledRAGAlerts: {
      type: 'boolean',
      _meta: {
        description: 'Is RAG on Alerts enabled',
        optional: true
      }
    },
    assistantStreamingEnabled: {
      type: 'boolean',
      _meta: {
        description: 'Is streaming enabled',
        optional: true
      }
    }
  }
};