"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInspectQuery = void 0;
var _lodash = require("lodash");
var _react = require("react");
var _helpers = require("../../helpers");
var _use_global_time = require("../containers/use_global_time");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Add and remove query response from global input store.
 */
const useInspectQuery = (id, loading, response, refetch = _lodash.noop) => {
  const {
    deleteQuery,
    setQuery,
    isInitializing
  } = (0, _use_global_time.useGlobalTime)();
  (0, _react.useEffect)(() => {
    if (!loading && !isInitializing && response !== null && response !== void 0 && response.inspect) {
      setQuery({
        id,
        inspect: (0, _helpers.getInspectResponse)(response, {
          dsl: [],
          response: []
        }),
        loading,
        refetch
      });
    }
    return () => {
      if (deleteQuery) {
        deleteQuery({
          id
        });
      }
    };
  }, [deleteQuery, setQuery, loading, response, isInitializing, id, refetch]);
};
exports.useInspectQuery = useInspectQuery;