"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInitFlyoutFromUrlParam = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _constants = require("../../../../common/constants");
var _global_query_string = require("../../utils/global_query_string");
var _use_url_state = require("../use_url_state");
var _use_selector = require("../use_selector");
var _kibana = require("../../lib/kibana");
var _use_query_timeline_by_id_on_url_change = require("../timeline/use_query_timeline_by_id_on_url_change");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * The state of the old flyout of the table in the Alerts page is stored in local storage.
 * This hook was created to initialize things and populate the url with the correct param and its value.
 * This is only be needed with the old flyout.
 * // TODO remove this hook entirely when we delete the old flyout code
 */

const useInitFlyoutFromUrlParam = () => {
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const [isSecurityFlyoutEnabled] = (0, _kibana.useUiSetting$)(_constants.ENABLE_EXPANDABLE_FLYOUT_SETTING);
  const [urlDetails, setUrlDetails] = (0, _react.useState)(null);
  const [hasLoadedUrlDetails, updateHasLoadedUrlDetails] = (0, _react.useState)(false);
  const dispatch = (0, _reactRedux.useDispatch)();
  const getDataTable = _securitysolutionDataTable.dataTableSelectors.getTableByIdSelector();

  // Only allow the alerts page for now to be saved in the url state.
  // Allowing only one makes the transition to the expanded flyout much easier as well
  const dataTableCurrent = (0, _use_selector.useShallowEqualSelector)(state => {
    var _getDataTable;
    return (_getDataTable = getDataTable(state, _securitysolutionDataTable.TableId.alertsOnAlertsPage)) !== null && _getDataTable !== void 0 ? _getDataTable : _securitysolutionDataTable.tableDefaults;
  });
  const onInitialize = (0, _react.useCallback)(initialState => {
    if (!isSecurityFlyoutEnabled && initialState != null && initialState.panelView) {
      setUrlDetails(initialState);
    }
  }, [isSecurityFlyoutEnabled]);
  const loadExpandedDetailFromUrl = (0, _react.useCallback)(() => {
    if (isSecurityFlyoutEnabled) return;
    const {
      initialized,
      isLoading,
      totalCount,
      additionalFilters
    } = dataTableCurrent;
    const isTableLoaded = initialized && !isLoading && totalCount > 0;
    if (urlDetails) {
      if (!additionalFilters || !additionalFilters.showBuildingBlockAlerts) {
        // We want to show building block alerts when loading the flyout in case the alert is a building block alert
        dispatch(_securitysolutionDataTable.dataTableActions.updateShowBuildingBlockAlertsFilter({
          id: _securitysolutionDataTable.TableId.alertsOnAlertsPage,
          showBuildingBlockAlerts: true
        }));
      }
      if (isTableLoaded) {
        updateHasLoadedUrlDetails(true);
        dispatch(_securitysolutionDataTable.dataTableActions.toggleDetailPanel({
          id: _securitysolutionDataTable.TableId.alertsOnAlertsPage,
          ...urlDetails
        }));
      }
    }
  }, [dataTableCurrent, dispatch, isSecurityFlyoutEnabled, urlDetails]);

  // The alert page creates a default dataTable slice in redux initially that is later overriden when data is retrieved
  // We use the below to store the urlDetails on app load, and then set it when the table is done loading and has data
  (0, _react.useEffect)(() => {
    if (!isSecurityFlyoutEnabled && !hasLoadedUrlDetails) {
      loadExpandedDetailFromUrl();
    }
  }, [hasLoadedUrlDetails, isSecurityFlyoutEnabled, loadExpandedDetailFromUrl]);

  // We check the url for the presence of the old `evenFlyout` parameter. If it exists replace it with the new `flyout` key.
  const eventFlyoutKey = (0, _use_query_timeline_by_id_on_url_change.getQueryStringKeyValue)({
    urlKey: _use_url_state.URL_PARAM_KEY.eventFlyout,
    search
  });
  let currentKey = '';
  let newKey = '';
  if (!isSecurityFlyoutEnabled) {
    if (eventFlyoutKey) {
      currentKey = _use_url_state.URL_PARAM_KEY.eventFlyout;
      newKey = _use_url_state.URL_PARAM_KEY.flyout;
    } else {
      currentKey = _use_url_state.URL_PARAM_KEY.flyout;
    }
  }
  (0, _global_query_string.useInitializeUrlParam)(currentKey, onInitialize, newKey);
};
exports.useInitFlyoutFromUrlParam = useInitFlyoutFromUrlParam;