"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataView = exports.getDataViewStateFromIndexFields = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _memoizeOne = _interopRequireDefault(require("memoize-one"));
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _kibana = require("../../lib/kibana");
var _sourcerer = require("../../store/sourcerer");
var _model = require("../../store/sourcerer/model");
var _get_sourcerer_data_view = require("../sourcerer/get_sourcerer_data_view");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_app_toasts = require("../../hooks/use_app_toasts");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * HOT Code path where the fields can be 16087 in length or larger. This is
 * VERY mutatious on purpose to improve the performance of the transform.
 */
const getDataViewStateFromIndexFields = exports.getDataViewStateFromIndexFields = (0, _memoizeOne.default)((_title, fields) => {
  // Adds two dangerous casts to allow for mutations within this function

  if (fields == null) {
    return {
      browserFields: {}
    };
  } else {
    const browserFields = {};
    for (const [name, field] of Object.entries(fields)) {
      const category = (0, _public.getCategory)(name);
      if (browserFields[category] == null) {
        browserFields[category] = {
          fields: {}
        };
      }
      const categoryFields = browserFields[category].fields;
      if (categoryFields) {
        categoryFields[name] = field;
      }
    }
    return {
      browserFields: browserFields
    };
  }
}, (newArgs, lastArgs) => {
  var _newArgs$, _lastArgs$;
  return newArgs[0] === lastArgs[0] && ((_newArgs$ = newArgs[1]) === null || _newArgs$ === void 0 ? void 0 : _newArgs$.length) === ((_lastArgs$ = lastArgs[1]) === null || _lastArgs$ === void 0 ? void 0 : _lastArgs$.length);
});
const useDataView = () => {
  const {
    data
  } = (0, _kibana.useKibana)().services;
  const abortCtrl = (0, _react.useRef)({});
  const searchSubscription$ = (0, _react.useRef)({});
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const setLoading = (0, _react.useCallback)(({
    id,
    loading
  }) => {
    dispatch(_sourcerer.sourcererActions.setDataViewLoading({
      id,
      loading
    }));
  }, [dispatch]);
  const indexFieldsSearch = (0, _react.useCallback)(({
    dataViewId,
    scopeId = _model.SourcererScopeName.default,
    needToBeInit = false,
    cleanCache = false,
    skipScopeUpdate = false
  }) => {
    const asyncSearch = async () => {
      try {
        abortCtrl.current = {
          ...abortCtrl.current,
          [dataViewId]: new AbortController()
        };
        setLoading({
          id: dataViewId,
          loading: true
        });
        const dataView = await (0, _get_sourcerer_data_view.getSourcererDataView)(dataViewId, data.dataViews, cleanCache);
        if (needToBeInit && scopeId && !skipScopeUpdate) {
          dispatch(_sourcerer.sourcererActions.setSelectedDataView({
            id: scopeId,
            selectedDataViewId: dataViewId,
            selectedPatterns: dataView.patternList
          }));
        }
        dispatch(_sourcerer.sourcererActions.setDataView({
          ...dataView,
          loading: false
        }));
      } catch (exc) {
        addError(exc === null || exc === void 0 ? void 0 : exc.message, {
          title: i18n.ERROR_INDEX_FIELDS_SEARCH
        });
      }
    };
    if (searchSubscription$.current[dataViewId]) {
      searchSubscription$.current[dataViewId].unsubscribe();
    }
    if (abortCtrl.current[dataViewId]) {
      abortCtrl.current[dataViewId].abort();
    }
    return asyncSearch();
  }, [setLoading, data.dataViews, dispatch, addError]);
  return {
    indexFieldsSearch
  };
};
exports.useDataView = useDataView;