"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInvestigationTimeEnrichment = exports.QUERY_ID = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _lodash = require("lodash");
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _constants = require("../../../store/inputs/constants");
var _constants2 = require("../../../../../common/cti/constants");
var _use_app_toasts = require("../../../hooks/use_app_toasts");
var _kibana = require("../../../lib/kibana");
var _actions = require("../../../store/actions");
var i18n = _interopRequireWildcard(require("./translations"));
var _ = require(".");
var _constants3 = require("../../../../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QUERY_ID = exports.QUERY_ID = 'investigation_time_enrichment';
const noop = () => {};
const noEnrichments = {
  enrichments: []
};
const useInvestigationTimeEnrichment = eventFields => {
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    data,
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const defaultThreatIndices = uiSettings.get(_constants3.DEFAULT_THREAT_INDEX_KEY);
  const dispatch = (0, _reactRedux.useDispatch)();
  const [range, setRange] = (0, _react.useState)({
    from: _constants2.DEFAULT_EVENT_ENRICHMENT_FROM,
    to: _constants2.DEFAULT_EVENT_ENRICHMENT_TO
  });
  const {
    error,
    loading,
    result,
    start
  } = (0, _.useEventEnrichmentComplete)();
  const deleteQuery = (0, _react.useCallback)(() => {
    dispatch(_actions.inputsActions.deleteOneQuery({
      inputId: _constants.InputsModelId.global,
      id: QUERY_ID
    }));
  }, [dispatch]);
  (0, _react.useEffect)(() => {
    if (!loading && result) {
      dispatch(_actions.inputsActions.setQuery({
        inputId: _constants.InputsModelId.global,
        id: QUERY_ID,
        inspect: {
          dsl: result.inspect.dsl,
          response: [JSON.stringify(result.rawResponse, null, 2)]
        },
        loading,
        refetch: noop
      }));
    }
    return deleteQuery;
  }, [deleteQuery, dispatch, loading, result]);
  (0, _react.useEffect)(() => {
    if (error) {
      addError(error, {
        title: i18n.INVESTIGATION_ENRICHMENT_REQUEST_ERROR
      });
    }
  }, [addError, error]);
  const prevEventFields = (0, _usePrevious.default)(eventFields);
  const prevRange = (0, _usePrevious.default)(range);
  (0, _react.useEffect)(() => {
    if (!(0, _lodash.isEmpty)(eventFields) && (!(0, _lodash.isEqual)(eventFields, prevEventFields) || !(0, _lodash.isEqual)(range, prevRange))) {
      start({
        data,
        timerange: {
          ...range,
          interval: ''
        },
        defaultIndex: defaultThreatIndices,
        eventFields,
        filterQuery: ''
      });
    }
  }, [start, data, eventFields, prevEventFields, range, prevRange, defaultThreatIndices]);
  return {
    result: (0, _lodash.isEmpty)(eventFields) ? noEnrichments : result,
    range,
    setRange,
    loading
  };
};
exports.useInvestigationTimeEnrichment = useInvestigationTimeEnrichment;