"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useVisualizationResponse = void 0;
var _react = require("react");
var _utils = require("./utils");
var _use_selector = require("../../hooks/use_selector");
var _store = require("../../store");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useVisualizationResponse = ({
  visualizationId
}) => {
  const getGlobalQuery = (0, _react.useMemo)(() => _store.inputsSelectors.globalQueryByIdSelector(), []);
  const {
    inspect,
    loading,
    searchSessionId
  } = (0, _use_selector.useDeepEqualSelector)(state => getGlobalQuery(state, visualizationId));
  const response = (0, _react.useMemo)(() => ({
    requests: inspect ? (0, _utils.parseVisualizationData)(inspect === null || inspect === void 0 ? void 0 : inspect.dsl) : null,
    responses: inspect ? (0, _utils.parseVisualizationData)(inspect === null || inspect === void 0 ? void 0 : inspect.response) : null,
    loading,
    searchSessionId
  }), [inspect, loading, searchSessionId]);
  return response;
};
exports.useVisualizationResponse = useVisualizationResponse;